/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectAction;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marco Leo
 */
@Component(
	property = "indexer.class.name=com.liferay.object.model.ObjectAction",
	service = ModelDocumentContributor.class
)
public class ObjectActionModelDocumentContributor
	implements ModelDocumentContributor<ObjectAction> {

	@Override
	public void contribute(Document document, ObjectAction objectAction) {
		document.addText(Field.NAME, objectAction.getName());
		document.addLocalizedText(
			"label",
			_localization.populateLocalizationMap(
				objectAction.getLabelMap(), objectAction.getDefaultLanguageId(),
				0));
		document.addKeyword(
			"objectDefinitionId", objectAction.getObjectDefinitionId());
		document.remove(Field.USER_NAME);
	}

	@Reference
	private Localization _localization;

}