/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.rest.context.path;

import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Marco Leo
 */
public class RESTContextPathResolverImpl implements RESTContextPathResolver {

	public RESTContextPathResolverImpl(
		String contextPath, ObjectScopeProvider objectScopeProvider,
		boolean system) {

		_objectScopeProvider = objectScopeProvider;

		if (objectScopeProvider.isGroupAware() && !system) {
			_contextPath = contextPath + "/scopes/{scopeKey}";
		}
		else {
			_contextPath = contextPath;
		}
	}

	@Override
	public String getRESTContextPath(long groupId) {
		if (!_objectScopeProvider.isGroupAware() ||
			!_objectScopeProvider.isValidGroupId(groupId)) {

			return _contextPath;
		}

		return StringUtil.replace(
			_contextPath, new String[] {"{groupId}", "{scopeKey}"},
			new String[] {String.valueOf(groupId), String.valueOf(groupId)});
	}

	private final String _contextPath;
	private final ObjectScopeProvider _objectScopeProvider;

}