/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.filter.parser;

import com.liferay.object.constants.ObjectFilterConstants;
import com.liferay.object.model.ObjectFilter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;

import java.util.Map;
import java.util.Objects;

import org.osgi.service.component.annotations.Component;

/**
 * @author Feliphe Marinho
 */
@Component(
	property = "filter.type=" + ObjectFilterConstants.TYPE_DATE_RANGE,
	service = ObjectFilterParser.class
)
public class DateRangeObjectFilterParser implements ObjectFilterParser {

	@Override
	public String parse(ObjectFilter objectFilter) {
		Map<String, Object> map = ObjectMapperUtil.readValue(
			Map.class, objectFilter.getJSON());

		String ge = String.valueOf(map.get("ge"));
		String le = String.valueOf(map.get("le"));

		String filterBy = objectFilter.getFilterBy();

		if (Objects.equals(objectFilter.getFilterBy(), "createDate") ||
			Objects.equals(objectFilter.getFilterBy(), "modifiedDate")) {

			ge += "T00:00:00.000Z";
			le += "T23:59:59.999Z";

			if (Objects.equals(objectFilter.getFilterBy(), "createDate")) {
				filterBy = "dateCreated";
			}
			else {
				filterBy = "dateModified";
			}
		}

		return StringBundler.concat(
			"((", filterBy, " ge ", ge, ") and (", filterBy, " le ", le, "))");
	}

}