/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.field.setting.contributor;

import com.liferay.object.constants.ObjectFieldSettingConstants;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectStateTransitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Feliphe Marinho
 */
@Component(
	property = "object.field.setting.type.key=" + ObjectFieldSettingConstants.NAME_STATE_FLOW,
	service = ObjectFieldSettingContributor.class
)
public class StateFlowObjectFieldSettingContributor
	implements ObjectFieldSettingContributor {

	@Override
	public void updateObjectFieldSetting(
			long oldObjectFieldSettingId,
			ObjectFieldSetting newObjectFieldSetting)
		throws PortalException {

		_objectStateTransitionLocalService.updateObjectStateTransitions(
			newObjectFieldSetting.getObjectStateFlow());
	}

	@Reference
	private ObjectStateTransitionLocalService
		_objectStateTransitionLocalService;

}