/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.dynamic.data.mapping.expression;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;

import java.util.Locale;
import java.util.Map;

/**
 * @author Paulo Albuquerque
 */
public class ObjectEntryDDMExpressionParameterAccessor
	implements DDMExpressionParameterAccessor {

	public ObjectEntryDDMExpressionParameterAccessor(
		Map<String, Object> oldValues) {

		_oldValues = oldValues;
	}

	@Override
	public long getCompanyId() {
		return 0L;
	}

	@Override
	public String getGooglePlacesAPIKey() {
		return StringPool.BLANK;
	}

	@Override
	public long getGroupId() {
		return 0L;
	}

	@Override
	public Locale getLocale() {
		return null;
	}

	@Override
	public JSONArray getObjectFieldsJSONArray() {
		return JSONFactoryUtil.createJSONArray();
	}

	@Override
	public Map<String, Object> getObjectFieldsOldValues() {
		return _oldValues;
	}

	@Override
	public String getTimeZoneId() {
		return StringPool.BLANK;
	}

	@Override
	public long getUserId() {
		return 0L;
	}

	private final Map<String, Object> _oldValues;

}