/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectDefinitionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectDefinitionLocalService {
    protected ObjectDefinitionLocalService objectDefinitionLocalService;
    @Reference
    protected ObjectDefinitionPersistence objectDefinitionPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addObjectDefinition(ObjectDefinition objectDefinition) {
        objectDefinition.setNew(true);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Transactional(enabled=false)
    public ObjectDefinition createObjectDefinition(long objectDefinitionId) {
        return this.objectDefinitionPersistence.create(objectDefinitionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.remove(objectDefinitionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        return (ObjectDefinition)this.objectDefinitionPersistence.remove((BaseModel)objectDefinition);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectDefinitionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectDefinition.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectDefinitionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectDefinitionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectDefinitionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectDefinitionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectDefinitionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectDefinition fetchObjectDefinition(long objectDefinitionId) {
        return this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
    }

    public ObjectDefinition fetchObjectDefinitionByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectDefinitionPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectDefinition fetchObjectDefinitionByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.objectDefinitionPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public ObjectDefinition getObjectDefinitionByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.objectDefinitionPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectDefinitionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectDefinition.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectDefinitionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectDefinitionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectDefinition.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectDefinitionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectDefinitionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectDefinition.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectDefinitionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectDefinition>(){

            public void performAction(ObjectDefinition objectDefinition) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectDefinition);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectDefinition.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectDefinitionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectDefinitionLocalServiceImpl#deleteObjectDefinition(ObjectDefinition) to avoid orphaned data");
        }
        return this.objectDefinitionLocalService.deleteObjectDefinition((ObjectDefinition)persistedModel);
    }

    public BasePersistence<ObjectDefinition> getBasePersistence() {
        return this.objectDefinitionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectDefinitionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectDefinition getObjectDefinitionByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectDefinitionPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectDefinition> getObjectDefinitions(int start, int end) {
        return this.objectDefinitionPersistence.findAll(start, end);
    }

    public int getObjectDefinitionsCount() {
        return this.objectDefinitionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateObjectDefinition(ObjectDefinition objectDefinition) {
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectDefinitionLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectDefinitionLocalService = (ObjectDefinitionLocalService)aopProxy;
        this._setLocalServiceUtilService(this.objectDefinitionLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return ObjectDefinitionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectDefinition.class;
    }

    protected String getModelClassName() {
        return ObjectDefinition.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.objectDefinitionPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(ObjectDefinitionLocalService objectDefinitionLocalService) {
        try {
            Field field = ObjectDefinitionLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, objectDefinitionLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

