/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v3_18_0;

import com.liferay.object.model.ObjectEntryTable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;

public class ObjectFieldUpgradeProcess
extends UpgradeProcess {
    private final PortalUUID _portalUUID;

    public ObjectFieldUpgradeProcess(PortalUUID portalUUID) {
        this._portalUUID = portalUUID;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ObjectDefinition.companyId, ", "ObjectDefinition.dbTableName, ", "ObjectDefinition.objectDefinitionId, ", "ObjectDefinition.userName, ObjectDefinition.userId, ", "ObjectDefinition.system_ from ObjectDefinition where ", "ObjectDefinition.objectDefinitionId not in (select ", "distinct ObjectField.objectDefinitionId from ", "ObjectField where (ObjectField.name = 'creator' or ", "ObjectField.name = 'createDate' or ObjectField.name ", "= 'id' or ObjectField.name = 'modifiedDate' or ", "ObjectField.name = 'status') and ObjectField.system_ ", "= [$TRUE$])"})));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into ObjectField (mvccVersion, uuid_, ", "objectFieldId, companyId, userId, userName, ", "createDate, modifiedDate, externalReferenceCode, ", "listTypeDefinitionId, objectDefinitionId, ", "businessType, dbColumnName, dbTableName, dbType, ", "defaultValue, indexed, indexedAsKeyWord, ", "indexedLanguageId, label, name, relationshipType, ", "required, state_, system_) values (?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String dbTableName = resultSet.getString("dbTableName");
                final Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
                long objectDefinitionId = resultSet.getLong("objectDefinitionId");
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                if (!resultSet.getBoolean("system_")) {
                    dbTableName = "ObjectEntry";
                }
                this._insertObjectField(preparedStatement2, companyId, userId, userName, timestamp, objectDefinitionId, "Text", ObjectEntryTable.INSTANCE.userName.getName(), dbTableName, "String", LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
                    {
                        this.put(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)"author"));
                    }
                }, (String)"Label"), "creator");
                this._insertObjectField(preparedStatement2, companyId, userId, userName, timestamp, objectDefinitionId, "Date", ObjectEntryTable.INSTANCE.createDate.getName(), dbTableName, "Date", LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
                    {
                        this.put(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)"create-date"));
                    }
                }, (String)"Label"), "createDate");
                this._insertObjectField(preparedStatement2, companyId, userId, userName, timestamp, objectDefinitionId, "LongInteger", ObjectEntryTable.INSTANCE.objectEntryId.getName(), dbTableName, "Long", LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
                    {
                        this.put(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)"id"));
                    }
                }, (String)"Label"), "id");
                this._insertObjectField(preparedStatement2, companyId, userId, userName, timestamp, objectDefinitionId, "Date", ObjectEntryTable.INSTANCE.modifiedDate.getName(), dbTableName, "Date", LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
                    {
                        this.put(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)"modified-date"));
                    }
                }, (String)"Label"), "modifiedDate");
                this._insertObjectField(preparedStatement2, companyId, userId, userName, timestamp, objectDefinitionId, "Text", ObjectEntryTable.INSTANCE.status.getName(), dbTableName, "Integer", LocalizationUtil.getXml((LocalizedValuesMap)new LocalizedValuesMap(){
                    {
                        this.put(defaultLocale, LanguageUtil.get((Locale)defaultLocale, (String)"status"));
                    }
                }, (String)"Label"), "status");
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _insertObjectField(PreparedStatement preparedStatement, long companyId, long userId, String userName, Timestamp timestamp, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, String label, String name) throws SQLException {
        preparedStatement.setLong(1, 0L);
        String uuid = this._portalUUID.generate();
        preparedStatement.setString(2, uuid);
        preparedStatement.setLong(3, this.increment());
        preparedStatement.setLong(4, companyId);
        preparedStatement.setLong(5, userId);
        preparedStatement.setString(6, userName);
        preparedStatement.setTimestamp(7, timestamp);
        preparedStatement.setTimestamp(8, timestamp);
        preparedStatement.setString(9, uuid);
        preparedStatement.setLong(10, 0L);
        preparedStatement.setLong(11, objectDefinitionId);
        preparedStatement.setString(12, businessType);
        preparedStatement.setString(13, dbColumnName);
        preparedStatement.setString(14, dbTableName);
        preparedStatement.setString(15, dbType);
        preparedStatement.setString(16, null);
        preparedStatement.setBoolean(17, false);
        preparedStatement.setBoolean(18, false);
        preparedStatement.setString(19, null);
        preparedStatement.setString(20, label);
        preparedStatement.setString(21, name);
        preparedStatement.setString(22, null);
        preparedStatement.setBoolean(23, false);
        preparedStatement.setBoolean(24, false);
        preparedStatement.setBoolean(25, true);
        preparedStatement.addBatch();
    }
}

