/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.system;

import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class UserSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private UserAccountResource.Factory _userAccountResourceFactory;
    @Reference
    private UserLocalService _userLocalService;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        UserAccountResource userAccountResource = this._buildUserAccountResource(user);
        UserAccount userAccount = userAccountResource.postUserAccount(this._toUserAccount(values));
        this.setExtendedProperties(UserAccount.class.getName(), userAccount, user, values);
        return userAccount.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._userLocalService.deleteUser((User)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._userLocalService.fetchUserByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._userLocalService.getUserByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getExternalReferenceCode(long primaryKey) throws PortalException {
        User user = this._userLocalService.getUser(primaryKey);
        return user.getExternalReferenceCode();
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Admin.User", "headless-admin-user", "user-accounts", "v1.0");
    }

    public Map<Locale, String> getLabelMap() {
        return this.createLabelMap("user");
    }

    public Class<?> getModelClass() {
        return User.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(this.createObjectField("Text", "middleName", "String", "middle-name", "additionalName", false, true), this.createObjectField("Text", "screenName", "String", "screen-name", "alternateName", true, true), this.createObjectField("Text", "String", "email-address", "emailAddress", true, true), this.createObjectField("Text", "lastName", "String", "last-name", "familyName", true, true), this.createObjectField("Text", "firstName", "String", "first-name", "givenName", true, true), this.createObjectField("Date", "lastLoginDate", "Date", "last-login-date", "lastLoginDate", false, true), this.createObjectField("Text", "uuid_", "String", "uuid", "uuid", false, true));
    }

    public Map<Locale, String> getPluralLabelMap() {
        return this.createLabelMap("users");
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return UserTable.INSTANCE.userId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return UserTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "givenName";
    }

    public Map<String, Object> getVariables(String contentType, ObjectDefinition objectDefinition, boolean oldValues, JSONObject payloadJSONObject) {
        Map variables = super.getVariables(contentType, objectDefinition, oldValues, payloadJSONObject);
        if (variables.containsKey("firstName")) {
            variables.put("givenName", variables.get("firstName"));
        }
        if (variables.containsKey("lastName")) {
            variables.put("familyName", variables.get("lastName"));
        }
        if (variables.containsKey("middleName")) {
            variables.put("additionalName", variables.get("middleName"));
        }
        if (variables.containsKey("screenName")) {
            variables.put("alternateName", variables.get("screenName"));
        }
        return variables;
    }

    public int getVersion() {
        return 3;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        UserAccountResource userAccountResource = this._buildUserAccountResource(user);
        UserAccount userAccount = userAccountResource.patchUserAccount(Long.valueOf(primaryKey), this._toUserAccount(values));
        this.setExtendedProperties(UserAccount.class.getName(), userAccount, user, values);
    }

    private UserAccountResource _buildUserAccountResource(User user) {
        UserAccountResource.Builder builder = this._userAccountResourceFactory.create();
        return builder.checkPermissions(false).preferredLocale(user.getLocale()).user(user).build();
    }

    private UserAccount _toUserAccount(final Map<String, Object> values) {
        return new UserAccount(){
            {
                this.additionalName = GetterUtil.getString(values.get("additionalName"));
                this.alternateName = GetterUtil.getString(values.get("alternateName"));
                this.emailAddress = GetterUtil.getString(values.get("emailAddress"));
                this.externalReferenceCode = GetterUtil.getString(values.get("externalReferenceCode"));
                this.familyName = GetterUtil.getString(values.get("familyName"));
                this.givenName = GetterUtil.getString(values.get("givenName"));
            }
        };
    }
}

