/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectDefinitionModelListener
extends BaseModelListener<ObjectDefinition> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectDefinition objectDefinition) throws ModelListenerException {
        this._route("ADD", objectDefinition);
    }

    public void onBeforeRemove(ObjectDefinition objectDefinition) throws ModelListenerException {
        this._route("DELETE", objectDefinition);
    }

    public void onBeforeUpdate(ObjectDefinition originalObjectDefinition, ObjectDefinition objectDefinition) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectDefinition.class.getName(), (long)objectDefinition.getObjectDefinitionId(), this._getModifiedAttributes(originalObjectDefinition, objectDefinition)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectDefinition originalObjectDefinition, ObjectDefinition objectDefinition) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectDefinition, (Object)originalObjectDefinition);
        attributesBuilder.add("active");
        attributesBuilder.add("descriptionObjectFieldId");
        attributesBuilder.add("labelMap");
        attributesBuilder.add("name");
        attributesBuilder.add("panelAppOrder");
        attributesBuilder.add("panelCategoryKey");
        attributesBuilder.add("pluralLabelMap");
        attributesBuilder.add("portlet");
        attributesBuilder.add("scope");
        attributesBuilder.add("titleObjectFieldId");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectDefinition objectDefinition) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectDefinition.class.getName(), (long)objectDefinition.getObjectDefinitionId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("active", objectDefinition.isActive()).put("labelMap", (Object)objectDefinition.getLabelMap()).put("name", objectDefinition.getName()).put("scope", objectDefinition.getScope());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

