/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorView;
import com.liferay.item.selector.ItemSelectorViewDescriptorRenderer;
import com.liferay.item.selector.criteria.info.item.criterion.InfoItemItemSelectorCriterion;
import com.liferay.notification.handler.NotificationHandler;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.internal.item.selector.SystemObjectEntryItemSelectorView;
import com.liferay.object.internal.notification.handler.ObjectDefinitionNotificationHandler;
import com.liferay.object.internal.notification.term.contributor.ObjectDefinitionNotificationTermEvaluator;
import com.liferay.object.internal.related.models.SystemObject1toMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.related.models.SystemObjectMtoMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.rest.context.path.RESTContextPathResolverImpl;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.osgi.service.tracker.collections.EagerServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.EveryNodeEveryStartup;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Portal;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={PortalInstanceLifecycleListener.class})
public class SystemObjectDefinitionManagerPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener
implements EveryNodeEveryStartup {
    private static final Log _log = LogFactoryUtil.getLog(SystemObjectDefinitionManagerPortalInstanceLifecycleListener.class);
    private static final ThreadLocal<Boolean> _openingThreadLocal = new CentralizedThreadLocal(SystemObjectDefinitionManagerPortalInstanceLifecycleListener.class.getName() + "._openingThreadLocal", () -> Boolean.FALSE);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private ItemSelectorViewDescriptorRenderer<InfoItemItemSelectorCriterion> _itemSelectorViewDescriptorRenderer;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private Portal _portal;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.object.service)(release.schema.version>=1.0.0))")
    private Release _release;
    private ServiceTrackerList<SystemObjectDefinitionManager> _serviceTrackerList;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered portal instance " + company));
        }
        for (SystemObjectDefinitionManager systemObjectDefinitionManager : this._serviceTrackerList) {
            this._apply(company.getCompanyId(), systemObjectDefinitionManager);
        }
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + bundleContext));
        }
        this._bundleContext = bundleContext;
        _openingThreadLocal.set(Boolean.TRUE);
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, SystemObjectDefinitionManager.class, null, (ServiceTrackerCustomizer)new EagerServiceTrackerCustomizer<SystemObjectDefinitionManager, SystemObjectDefinitionManager>(){

            public SystemObjectDefinitionManager addingService(ServiceReference<SystemObjectDefinitionManager> serviceReference) {
                SystemObjectDefinitionManager systemObjectDefinitionManager = (SystemObjectDefinitionManager)bundleContext.getService(serviceReference);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding service " + systemObjectDefinitionManager));
                }
                if (!((Boolean)_openingThreadLocal.get()).booleanValue()) {
                    SystemObjectDefinitionManagerPortalInstanceLifecycleListener.this._companyLocalService.forEachCompanyId(companyId -> SystemObjectDefinitionManagerPortalInstanceLifecycleListener.this._apply(companyId, systemObjectDefinitionManager));
                }
                return systemObjectDefinitionManager;
            }

            public void modifiedService(ServiceReference<SystemObjectDefinitionManager> serviceReference, SystemObjectDefinitionManager systemObjectDefinitionManager) {
            }

            public void removedService(ServiceReference<SystemObjectDefinitionManager> serviceReference, SystemObjectDefinitionManager systemObjectDefinitionManager) {
                bundleContext.ungetService(serviceReference);
            }
        });
        _openingThreadLocal.set(Boolean.FALSE);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    private void _apply(long companyId, SystemObjectDefinitionManager systemObjectDefinitionManager) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Applying ", systemObjectDefinitionManager, " to company ", companyId}));
        }
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(companyId, systemObjectDefinitionManager.getName());
            if (objectDefinition == null || objectDefinition.getVersion() != systemObjectDefinitionManager.getVersion()) {
                objectDefinition = this._objectDefinitionLocalService.addOrUpdateSystemObjectDefinition(companyId, systemObjectDefinitionManager);
            }
            this._bundleContext.registerService(ItemSelectorView.class, (Object)new SystemObjectEntryItemSelectorView(this._itemSelector, this._itemSelectorViewDescriptorRenderer, objectDefinition, this._objectFieldLocalService, this._objectRelatedModelsProviderRegistry, this._portal), (Dictionary)HashMapDictionaryBuilder.put((Object)"item.selector.view.order", (Object)500).build());
            this._bundleContext.registerService(NotificationTermEvaluator.class, (Object)new ObjectDefinitionNotificationTermEvaluator(this._listTypeLocalService, objectDefinition, this._objectDefinitionLocalService, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build());
            this._bundleContext.registerService(NotificationHandler.class, (Object)new ObjectDefinitionNotificationHandler(objectDefinition), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build());
            this._bundleContext.registerService(ObjectRelatedModelsProvider.class, new SystemObject1toMObjectRelatedModelsProviderImpl(objectDefinition, this._objectDefinitionLocalService, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._persistedModelLocalServiceRegistry, systemObjectDefinitionManager, this._systemObjectDefinitionManagerRegistry), null);
            this._bundleContext.registerService(ObjectRelatedModelsProvider.class, new SystemObjectMtoMObjectRelatedModelsProviderImpl(objectDefinition, this._objectDefinitionLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._persistedModelLocalServiceRegistry, systemObjectDefinitionManager, this._systemObjectDefinitionManagerRegistry), null);
            JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
            this._bundleContext.registerService(RESTContextPathResolver.class, (Object)new RESTContextPathResolverImpl("/o/" + jaxRsApplicationDescriptor.getRESTContextPath(), this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope()), true), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }
}

