/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.info.collection.provider;

import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.util.Collections;
import java.util.Locale;

public abstract class BaseObjectRelationshipRelatedInfoCollectionProvider
implements RelatedInfoItemCollectionProvider {
    protected final ObjectEntryLocalService objectEntryLocalService;
    protected final ObjectRelationship objectRelationship;
    private static final Log _log = LogFactoryUtil.getLog(BaseObjectRelationshipRelatedInfoCollectionProvider.class);
    private final Language _language;
    private final ObjectDefinition _objectDefinition1;
    private final ObjectDefinition _objectDefinition2;

    public BaseObjectRelationshipRelatedInfoCollectionProvider(Language language, ObjectDefinition objectDefinition1, ObjectDefinition objectDefinition2, ObjectEntryLocalService objectEntryLocalService, ObjectRelationship objectRelationship) {
        this._language = language;
        this.objectEntryLocalService = objectEntryLocalService;
        this.objectRelationship = objectRelationship;
        this._objectDefinition1 = objectDefinition1;
        this._objectDefinition2 = objectDefinition2;
    }

    public InfoPage<ObjectEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        if (!(relatedItem instanceof ObjectEntry)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        try {
            return this.getCollectionInfoPage((ObjectEntry)relatedItem, collectionQuery.getPagination());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getCollectionItemClassName() {
        return this._objectDefinition2.getClassName();
    }

    public String getKey() {
        return StringBundler.concat((Object[])new Object[]{super.getKey(), "_", this._objectDefinition1.getCompanyId(), "_", this._objectDefinition1.getName(), "_", this.objectRelationship.getName()});
    }

    public String getLabel(Locale locale) {
        if (!this.objectRelationship.isSelf()) {
            return this.objectRelationship.getLabel(locale);
        }
        return StringBundler.concat((String[])new String[]{this.objectRelationship.getLabel(locale), " ", "(", this._language.get(locale, this.objectRelationship.isReverse() ? "child" : "parent"), ")"});
    }

    public String getSourceItemClassName() {
        return this._objectDefinition1.getClassName();
    }

    public boolean isAvailable() {
        return FeatureFlagManagerUtil.isEnabled((String)"LPS-176083") && this._objectDefinition1.getCompanyId() == CompanyThreadLocal.getCompanyId().longValue();
    }

    protected InfoPage<ObjectEntry> getCollectionInfoPage(ObjectEntry objectEntry, Pagination pagination) throws PortalException {
        return null;
    }
}

