/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Relationship"}, service={ObjectFieldBusinessType.class})
public class RelationshipObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "object-relationship";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "relationship");
    }

    public String getName() {
        return "Relationship";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"accountEntryRestrictedObjectField", () -> {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectField.getObjectDefinitionId());
            return objectDefinition.isAccountEntryRestricted() && Objects.equals(objectDefinition.getAccountEntryRestrictedObjectFieldId(), objectField.getObjectFieldId());
        }).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return SetUtil.fromArray((Object[])new String[]{"objectDefinition1ShortName", "objectRelationshipERCObjectFieldName"});
    }

    public Object getValue(ObjectField objectField, Map<String, Object> values) throws PortalException {
        if (!Objects.equals(objectField.getRelationshipType(), "oneToMany") || values.containsKey(objectField.getName())) {
            return values.get(objectField.getName());
        }
        String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
        if (!values.containsKey(objectRelationshipERCObjectFieldName)) {
            return null;
        }
        String externalReferenceCode = GetterUtil.getString((Object)values.get(objectRelationshipERCObjectFieldName));
        if (Validator.isNull((String)externalReferenceCode)) {
            return 0;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            BaseModel baseModel = systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(externalReferenceCode, objectDefinition.getCompanyId());
            return baseModel.getPrimaryKeyObj();
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(externalReferenceCode, objectDefinition.getObjectDefinitionId());
        return objectEntry.getObjectEntryId();
    }

    public boolean isVisible() {
        return true;
    }
}

