/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.service.ObjectValidationRuleLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectValidationRule service. Represents a row in the &quot;ObjectValidationRule&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectValidationRuleImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRuleImpl
 * @see ObjectValidationRule
 * @generated
 */
public abstract class ObjectValidationRuleBaseImpl
	extends ObjectValidationRuleModelImpl implements ObjectValidationRule {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object validation rule model instance should use the <code>ObjectValidationRule</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectValidationRuleLocalServiceUtil.addObjectValidationRule(this);
		}
		else {
			ObjectValidationRuleLocalServiceUtil.updateObjectValidationRule(
				this);
		}
	}

}