/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectState service. Represents a row in the &quot;ObjectState&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectStateModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectStateImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectStateImpl
 * @generated
 */
public class ObjectStateModelImpl
	extends BaseModelImpl<ObjectState> implements ObjectStateModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object state model instance should use the <code>ObjectState</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectState";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectStateId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"listTypeEntryId", Types.BIGINT}, {"objectStateFlowId", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectStateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("listTypeEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectStateFlowId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectState (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectStateId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,listTypeEntryId LONG,objectStateFlowId LONG)";

	public static final String TABLE_SQL_DROP = "drop table ObjectState";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectState.objectStateId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectState.objectStateId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LISTTYPEENTRYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTSTATEFLOWID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTSTATEID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectStateModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectStateId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectStateId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectStateId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectState.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectState.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectState, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectState, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectState, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectState)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectState, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectState, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectState)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectState, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectState, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectState, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectState, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<ObjectState, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectState::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectState::getUuid);
			attributeGetterFunctions.put(
				"objectStateId", ObjectState::getObjectStateId);
			attributeGetterFunctions.put(
				"companyId", ObjectState::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectState::getUserId);
			attributeGetterFunctions.put("userName", ObjectState::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectState::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectState::getModifiedDate);
			attributeGetterFunctions.put(
				"listTypeEntryId", ObjectState::getListTypeEntryId);
			attributeGetterFunctions.put(
				"objectStateFlowId", ObjectState::getObjectStateFlowId);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectState, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectState, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<ObjectState, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectState, Long>)ObjectState::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<ObjectState, String>)ObjectState::setUuid);
			attributeSetterBiConsumers.put(
				"objectStateId",
				(BiConsumer<ObjectState, Long>)ObjectState::setObjectStateId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectState, Long>)ObjectState::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectState, Long>)ObjectState::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectState, String>)ObjectState::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectState, Date>)ObjectState::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectState, Date>)ObjectState::setModifiedDate);
			attributeSetterBiConsumers.put(
				"listTypeEntryId",
				(BiConsumer<ObjectState, Long>)ObjectState::setListTypeEntryId);
			attributeSetterBiConsumers.put(
				"objectStateFlowId",
				(BiConsumer<ObjectState, Long>)
					ObjectState::setObjectStateFlowId);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectStateId() {
		return _objectStateId;
	}

	@Override
	public void setObjectStateId(long objectStateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectStateId = objectStateId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getListTypeEntryId() {
		return _listTypeEntryId;
	}

	@Override
	public void setListTypeEntryId(long listTypeEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_listTypeEntryId = listTypeEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalListTypeEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("listTypeEntryId"));
	}

	@Override
	public long getObjectStateFlowId() {
		return _objectStateFlowId;
	}

	@Override
	public void setObjectStateFlowId(long objectStateFlowId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectStateFlowId = objectStateFlowId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectStateFlowId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectStateFlowId"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectState.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectState.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectState toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectState>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectStateImpl objectStateImpl = new ObjectStateImpl();

		objectStateImpl.setMvccVersion(getMvccVersion());
		objectStateImpl.setUuid(getUuid());
		objectStateImpl.setObjectStateId(getObjectStateId());
		objectStateImpl.setCompanyId(getCompanyId());
		objectStateImpl.setUserId(getUserId());
		objectStateImpl.setUserName(getUserName());
		objectStateImpl.setCreateDate(getCreateDate());
		objectStateImpl.setModifiedDate(getModifiedDate());
		objectStateImpl.setListTypeEntryId(getListTypeEntryId());
		objectStateImpl.setObjectStateFlowId(getObjectStateFlowId());

		objectStateImpl.resetOriginalValues();

		return objectStateImpl;
	}

	@Override
	public ObjectState cloneWithOriginalValues() {
		ObjectStateImpl objectStateImpl = new ObjectStateImpl();

		objectStateImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectStateImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		objectStateImpl.setObjectStateId(
			this.<Long>getColumnOriginalValue("objectStateId"));
		objectStateImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectStateImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		objectStateImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectStateImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectStateImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectStateImpl.setListTypeEntryId(
			this.<Long>getColumnOriginalValue("listTypeEntryId"));
		objectStateImpl.setObjectStateFlowId(
			this.<Long>getColumnOriginalValue("objectStateFlowId"));

		return objectStateImpl;
	}

	@Override
	public int compareTo(ObjectState objectState) {
		long primaryKey = objectState.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectState)) {
			return false;
		}

		ObjectState objectState = (ObjectState)object;

		long primaryKey = objectState.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectState> toCacheModel() {
		ObjectStateCacheModel objectStateCacheModel =
			new ObjectStateCacheModel();

		objectStateCacheModel.mvccVersion = getMvccVersion();

		objectStateCacheModel.uuid = getUuid();

		String uuid = objectStateCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectStateCacheModel.uuid = null;
		}

		objectStateCacheModel.objectStateId = getObjectStateId();

		objectStateCacheModel.companyId = getCompanyId();

		objectStateCacheModel.userId = getUserId();

		objectStateCacheModel.userName = getUserName();

		String userName = objectStateCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectStateCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectStateCacheModel.createDate = createDate.getTime();
		}
		else {
			objectStateCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectStateCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectStateCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectStateCacheModel.listTypeEntryId = getListTypeEntryId();

		objectStateCacheModel.objectStateFlowId = getObjectStateFlowId();

		return objectStateCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectState, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectState, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectState, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectState)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectState>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectState.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectStateId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _listTypeEntryId;
	private long _objectStateFlowId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectState, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectState)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectStateId", _objectStateId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("listTypeEntryId", _listTypeEntryId);
		_columnOriginalValues.put("objectStateFlowId", _objectStateFlowId);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectStateId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("listTypeEntryId", 256L);

		columnBitmasks.put("objectStateFlowId", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectState _escapedModel;

}