/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.upgrade.v4_1_1;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;

/**
 * @author Julián Vela
 */
public class ObjectViewUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		_updateObjectFieldName("ObjectViewColumn", "createDate", "dateCreated");
		_updateObjectFieldName(
			"ObjectViewColumn", "modifiedDate", "dateModified");
		_updateObjectFieldName(
			"ObjectViewFilterColumn", "createDate", "dateCreated");
		_updateObjectFieldName(
			"ObjectViewFilterColumn", "modifiedDate", "dateModified");
		_updateObjectFieldName(
			"ObjectViewSortColumn", "createDate", "dateCreated");
		_updateObjectFieldName(
			"ObjectViewSortColumn", "modifiedDate", "dateModified");
	}

	private void _updateObjectFieldName(
			String dbTableName, String newObjectFieldName,
			String oldObjectFieldName)
		throws Exception {

		runSQL(
			StringBundler.concat(
				"update ", dbTableName, " set objectFieldName = '",
				newObjectFieldName, "' where objectFieldName = '",
				oldObjectFieldName, "'"));
	}

}