/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.upgrade.v3_19_2;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;

import java.sql.PreparedStatement;

import java.util.Map;

/**
 * @author Feliphe Marinho
 */
public class ObjectFieldUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		Map<String, String> map = HashMapBuilder.put(
			"AccountEntry", "accountEntryId"
		).put(
			"Address", "addressId"
		).put(
			"CommerceOrder", "commerceOrderId"
		).put(
			"CommercePricingClass", "commercePricingClassId"
		).put(
			"CPDefinition", "CPDefinitionId"
		).put(
			"User_", "userId"
		).build();

		try (PreparedStatement preparedStatement =
				AutoBatchPreparedStatementUtil.autoBatch(
					connection,
					"update ObjectField set dbColumnName = ? where name = " +
						"'id' and dbTableName = ?")) {

			for (Map.Entry<String, String> entry : map.entrySet()) {
				preparedStatement.setString(1, entry.getValue());
				preparedStatement.setString(2, entry.getKey());

				preparedStatement.addBatch();
			}

			preparedStatement.executeBatch();
		}
		catch (Exception exception) {
			_log.error(exception);

			throw exception;
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		ObjectFieldUpgradeProcess.class);

}