/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.scope;

import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.Collections;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Marco Leo
 */
@Component(service = ObjectScopeProviderRegistry.class)
public class ObjectScopeProviderRegistryImpl
	implements ObjectScopeProviderRegistry {

	@Override
	public ObjectScopeProvider getObjectScopeProvider(
		String objectScopeProviderKey) {

		ObjectScopeProvider objectScopeProvider = _serviceTrackerMap.getService(
			objectScopeProviderKey);

		if (objectScopeProvider == null) {
			throw new IllegalArgumentException(
				"No object scope provider found with key " +
					objectScopeProviderKey);
		}

		return objectScopeProvider;
	}

	@Override
	public List<ObjectScopeProvider> getObjectScopeProviders() {
		List<ObjectScopeProvider> objectScopeProviders =
			ListUtil.fromCollection(_serviceTrackerMap.values());

		if (objectScopeProviders == null) {
			return Collections.emptyList();
		}

		return objectScopeProviders;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, ObjectScopeProvider.class,
			"object.scope.provider.key");
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private ServiceTrackerMap<String, ObjectScopeProvider> _serviceTrackerMap;

}