/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.related.models;

import com.liferay.object.constants.ObjectRelationshipConstants;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.Map;

/**
 * @author Luis Miguel Barcos
 */
public class ObjectEntryMtoMObjectRelatedModelsPredicateProviderImpl
	extends BaseObjectEntryObjectRelatedModelsPredicateProviderImpl {

	public ObjectEntryMtoMObjectRelatedModelsPredicateProviderImpl(
		ObjectDefinition objectDefinition,
		ObjectFieldLocalService objectFieldLocalService) {

		super(objectDefinition, objectFieldLocalService);
	}

	@Override
	public String getObjectRelationshipType() {
		return ObjectRelationshipConstants.TYPE_MANY_TO_MANY;
	}

	@Override
	public Predicate getPredicate(
			ObjectRelationship objectRelationship, Predicate predicate)
		throws PortalException {

		Column<?, ?> dynamicObjectDefinitionTableColumn =
			getPKObjectFieldColumn(
				getDynamicObjectDefinitionTable(objectDefinition),
				objectDefinition.getPKObjectFieldDBColumnName());

		ObjectDefinition relatedObjectDefinition =
			ObjectDefinitionLocalServiceUtil.getObjectDefinition(
				_getRelatedObjectDefinitionId(
					objectDefinition.getObjectDefinitionId(),
					objectRelationship));

		Map<String, String> pkObjectFieldDBColumnNames =
			ObjectRelationshipUtil.getPKObjectFieldDBColumnNames(
				objectDefinition, relatedObjectDefinition,
				objectRelationship.isReverse());

		DynamicObjectRelationshipMappingTable
			dynamicObjectRelationshipMappingTable =
				new DynamicObjectRelationshipMappingTable(
					pkObjectFieldDBColumnNames.get(
						"pkObjectFieldDBColumnName1"),
					pkObjectFieldDBColumnNames.get(
						"pkObjectFieldDBColumnName2"),
					objectRelationship.getDBTableName());

		Column<DynamicObjectRelationshipMappingTable, ?>
			dynamicObjectRelationshipMappingTableColumn =
				(Column<DynamicObjectRelationshipMappingTable, ?>)
					getPKObjectFieldColumn(
						dynamicObjectRelationshipMappingTable,
						pkObjectFieldDBColumnNames.get(
							"pkObjectFieldDBColumnName2"));

		DynamicObjectDefinitionTable relatedDynamicObjectDefinitionTable =
			getDynamicObjectDefinitionTable(relatedObjectDefinition);
		DynamicObjectDefinitionTable relatedObjectDefinitionExtensionTable =
			getExtensionDynamicObjectDefinitionTable(relatedObjectDefinition);

		return dynamicObjectDefinitionTableColumn.in(
			DSLQueryFactoryUtil.select(
				getPKObjectFieldColumn(
					dynamicObjectRelationshipMappingTable,
					pkObjectFieldDBColumnNames.get(
						"pkObjectFieldDBColumnName1"))
			).from(
				dynamicObjectRelationshipMappingTable
			).where(
				dynamicObjectRelationshipMappingTableColumn.in(
					DSLQueryFactoryUtil.select(
						getPKObjectFieldColumn(
							relatedDynamicObjectDefinitionTable,
							relatedObjectDefinition.
								getPKObjectFieldDBColumnName())
					).from(
						relatedDynamicObjectDefinitionTable
					).innerJoinON(
						ObjectEntryTable.INSTANCE,
						ObjectEntryTable.INSTANCE.objectEntryId.eq(
							relatedDynamicObjectDefinitionTable.
								getPrimaryKeyColumn())
					).innerJoinON(
						relatedObjectDefinitionExtensionTable,
						relatedDynamicObjectDefinitionTable.getPrimaryKeyColumn(
						).eq(
							relatedObjectDefinitionExtensionTable.
								getPrimaryKeyColumn()
						)
					).where(
						predicate
					))
			));
	}

	private long _getRelatedObjectDefinitionId(
		long objectDefinitionId, ObjectRelationship objectRelationship) {

		if (objectRelationship.getObjectDefinitionId1() != objectDefinitionId) {
			return objectRelationship.getObjectDefinitionId1();
		}

		return objectRelationship.getObjectDefinitionId2();
	}

}