/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayoutColumn;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.constants.EventTypes;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcela Cunha
 */
@Component(service = ModelListener.class)
public class ObjectLayoutColumnModelListener
	extends BaseModelListener<ObjectLayoutColumn> {

	@Override
	public void onBeforeCreate(ObjectLayoutColumn objectLayoutColumn)
		throws ModelListenerException {

		_route(EventTypes.ADD, objectLayoutColumn);
	}

	@Override
	public void onBeforeRemove(ObjectLayoutColumn objectLayoutColumn)
		throws ModelListenerException {

		_route(EventTypes.DELETE, objectLayoutColumn);
	}

	@Override
	public void onBeforeUpdate(
			ObjectLayoutColumn originalObjectLayoutColumn,
			ObjectLayoutColumn objectLayoutColumn)
		throws ModelListenerException {

		try {
			_auditRouter.route(
				AuditMessageBuilder.buildAuditMessage(
					EventTypes.UPDATE, ObjectLayoutColumn.class.getName(),
					objectLayoutColumn.getObjectLayoutColumnId(),
					_getModifiedAttributes(
						originalObjectLayoutColumn, objectLayoutColumn)));
		}
		catch (Exception exception) {
			throw new ModelListenerException(exception);
		}
	}

	private List<Attribute> _getModifiedAttributes(
		ObjectLayoutColumn originalObjectLayoutColumn,
		ObjectLayoutColumn objectLayoutColumn) {

		AttributesBuilder attributesBuilder = new AttributesBuilder(
			objectLayoutColumn, originalObjectLayoutColumn);

		attributesBuilder.add("objectFieldId");
		attributesBuilder.add("objectLayoutRowId");
		attributesBuilder.add("priority");
		attributesBuilder.add("size");

		return attributesBuilder.getAttributes();
	}

	private void _route(String eventType, ObjectLayoutColumn objectLayoutColumn)
		throws ModelListenerException {

		try {
			AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage(
				eventType, ObjectLayoutColumn.class.getName(),
				objectLayoutColumn.getObjectLayoutColumnId(), null);

			JSONObject additionalInfoJSONObject =
				auditMessage.getAdditionalInfo();

			additionalInfoJSONObject.put(
				"objectFieldId", objectLayoutColumn.getObjectFieldId()
			).put(
				"objectLayoutRowId", objectLayoutColumn.getObjectLayoutRowId()
			).put(
				"priority", objectLayoutColumn.getPriority()
			).put(
				"size", objectLayoutColumn.getSize()
			);

			_auditRouter.route(auditMessage);
		}
		catch (Exception exception) {
			throw new ModelListenerException(exception);
		}
	}

	@Reference
	private AuditRouter _auditRouter;

}