/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.model.listener;

import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Feliphe Marinho
 */
@Component(service = ModelListener.class)
public class ListTypeEntryModelListener
	extends BaseModelListener<ListTypeEntry> {

	@Override
	public void onAfterCreate(ListTypeEntry listTypeEntry)
		throws ModelListenerException {

		List<ObjectField> objectFields =
			_objectFieldLocalService.getListTypeDefinitionObjectFields(
				listTypeEntry.getListTypeDefinitionId(), true);

		if (objectFields.isEmpty()) {
			return;
		}

		for (ObjectField objectField : objectFields) {
			ObjectStateFlow objectStateFlow =
				_objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(
					objectField.getObjectFieldId());

			try {
				_objectStateLocalService.addObjectState(
					listTypeEntry.getUserId(),
					listTypeEntry.getListTypeEntryId(),
					objectStateFlow.getObjectStateFlowId());
			}
			catch (PortalException portalException) {
				throw new ModelListenerException(portalException);
			}
		}
	}

	@Override
	public void onAfterRemove(ListTypeEntry listTypeEntry)
		throws ModelListenerException {

		_objectStateLocalService.deleteListTypeEntryObjectStates(
			listTypeEntry.getListTypeEntryId());
	}

	@Reference
	private ObjectFieldLocalService _objectFieldLocalService;

	@Reference
	private ObjectStateFlowLocalService _objectStateFlowLocalService;

	@Reference
	private ObjectStateLocalService _objectStateLocalService;

}