/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.filter.parser;

import com.liferay.object.constants.ObjectFilterConstants;
import com.liferay.object.model.ObjectFilter;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;

import java.util.Map;
import java.util.Objects;

import org.osgi.service.component.annotations.Component;

/**
 * @author Feliphe Marinho
 */
@Component(
	property = {
		"filter.type=" + ObjectFilterConstants.TYPE_EQUALS,
		"filter.type=" + ObjectFilterConstants.TYPE_NOT_EQUALS
	},
	service = ObjectFilterParser.class
)
public class EqualityOperatorsObjectFilterParser implements ObjectFilterParser {

	@Override
	public String parse(ObjectFilter objectFilter) {
		Map<String, Object> map = ObjectMapperUtil.readValue(
			Map.class, objectFilter.getJSON());

		String operator = "ne";

		if (Objects.equals(
				ObjectFilterConstants.TYPE_EQUALS,
				objectFilter.getFilterType())) {

			operator = "eq";
		}

		return StringBundler.concat(
			"( ", objectFilter.getFilterBy(), StringPool.SPACE, operator,
			StringPool.SPACE, String.valueOf(map.get(operator)), " )");
	}

}