/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.field.filter.parser;

import com.liferay.object.constants.ObjectViewFilterColumnConstants;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContext;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributor;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributorRegistry;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Feliphe Marinho
 */
@Component(service = ObjectFieldFilterContributorRegistry.class)
public class ObjectFieldFilterContributorRegistryImpl
	implements ObjectFieldFilterContributorRegistry {

	@Override
	public ObjectFieldFilterContributor getObjectFieldFilterContributor(
			ObjectFieldFilterContext objectFieldFilterContext)
		throws PortalException {

		ObjectViewFilterColumn objectViewFilterColumn =
			objectFieldFilterContext.getObjectViewFilterColumn();

		String key = objectViewFilterColumn.getFilterType();

		if (Validator.isNull(key)) {
			key = ObjectViewFilterColumnConstants.FILTER_TYPE_EXCLUDES;
		}

		ObjectFieldFilterContributor objectFieldFilterContributor =
			_serviceTrackerMap.getService(key);

		objectFieldFilterContributor.setObjectFieldFilterStrategy(
			objectFieldFilterContext);

		return objectFieldFilterContributor;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, ObjectFieldFilterContributor.class,
			"object.field.filter.type.key");
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private ServiceTrackerMap<String, ObjectFieldFilterContributor>
		_serviceTrackerMap;

}