/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.dynamic.data.mapping.expression;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyResponse;
import com.liferay.petra.string.StringPool;

import java.util.Map;

/**
 * @author Pedro Tavares
 */
public class ObjectEntryDDMExpressionFieldAccessor
	implements DDMExpressionFieldAccessor {

	public ObjectEntryDDMExpressionFieldAccessor(Map<String, Object> values) {
		_values = values;
	}

	@Override
	public GetFieldPropertyResponse getFieldProperty(
		GetFieldPropertyRequest getFieldPropertyRequest) {

		Object value = _values.get(getFieldPropertyRequest.getField());

		if ((value == null) && isField(getFieldPropertyRequest.getField())) {
			value = StringPool.BLANK;
		}

		GetFieldPropertyResponse.Builder builder =
			GetFieldPropertyResponse.Builder.newBuilder(value);

		return builder.build();
	}

	@Override
	public boolean isField(String parameter) {
		return _values.containsKey(parameter);
	}

	private final Map<String, Object> _values;

}