/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.exception.ObjectValidationRuleNameException;
import com.liferay.object.exception.ObjectValidationRuleScriptException;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.base.ObjectValidationRuleLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineRegistry;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleLocalServiceImpl
extends ObjectValidationRuleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectValidationRuleLocalServiceImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private ObjectValidationRuleEngineRegistry _objectValidationRuleEngineRegistry;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule addObjectValidationRule(long userId, long objectDefinitionId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        this._validateEngine(engine);
        this._validateName(nameMap);
        this._validateScript(engine, script);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectValidationRule.setCompanyId(user.getCompanyId());
        objectValidationRule.setUserId(user.getUserId());
        objectValidationRule.setUserName(user.getFullName());
        objectValidationRule.setObjectDefinitionId(objectDefinitionId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setScript(script);
        return (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectValidationRule deleteObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        return this.deleteObjectValidationRule(objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectValidationRule deleteObjectValidationRule(ObjectValidationRule objectValidationRule) {
        return (ObjectValidationRule)this.objectValidationRulePersistence.remove((BaseModel)objectValidationRule);
    }

    public void deleteObjectValidationRules(Long objectDefinitionId) throws PortalException {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            this.objectValidationRuleLocalService.deleteObjectValidationRule(objectValidationRule);
        }
    }

    @Override
    public ObjectValidationRule getObjectValidationRule(long objectValidationRuleId) throws PortalException {
        return this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId) {
        return this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId);
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, boolean active) {
        return this.objectValidationRulePersistence.findByODI_A(objectDefinitionId, active);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule updateObjectValidationRule(long objectValidationRuleId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String script) throws PortalException {
        this._validateEngine(engine);
        this._validateName(nameMap);
        this._validateScript(engine, script);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setScript(script);
        return (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
    }

    @Transactional(readOnly=true)
    public void validate(BaseModel<?> baseModel, long objectDefinitionId, JSONObject payloadJSONObject, long userId) throws PortalException {
        if (baseModel == null) {
            return;
        }
        List objectValidationRules = this.objectValidationRuleLocalService.getObjectValidationRules(objectDefinitionId, true);
        if (ListUtil.isEmpty((List)objectValidationRules)) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        Map<String, Object> variables = ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionMetadataRegistry);
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            Map results = new HashMap();
            ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(objectValidationRule.getEngine());
            results = StringUtil.equals((String)objectValidationRuleEngine.getName(), (String)"ddm") ? objectValidationRuleEngine.execute(variables, objectValidationRule.getScript()) : objectValidationRuleEngine.execute((Map)variables.get("baseModel"), objectValidationRule.getScript());
            if (GetterUtil.getBoolean(results.get("invalidFields"))) {
                throw new ObjectValidationRuleEngineException.InvalidFields(objectValidationRule.getErrorLabel(LocaleUtil.getMostRelevantLocale()));
            }
            if (!GetterUtil.getBoolean(results.get("invalidScript"))) continue;
            throw new ObjectValidationRuleEngineException.InvalidScript();
        }
    }

    private void _validateEngine(String engine) throws PortalException {
        if (Validator.isNull((String)engine)) {
            throw new ObjectValidationRuleEngineException.MustNotBeNull();
        }
        ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(engine);
        if (objectValidationRuleEngine == null) {
            throw new ObjectValidationRuleEngineException.NoSuchEngine(engine);
        }
    }

    private void _validateName(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap == null || Validator.isNull((String)nameMap.get(locale))) {
            throw new ObjectValidationRuleNameException("Name is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateScript(String engine, String script) throws PortalException {
        if (Validator.isNull((String)script)) {
            throw new ObjectValidationRuleScriptException("required");
        }
        try {
            if (Objects.equals(engine, "ddm")) {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
            } else if (Objects.equals(engine, "groovy")) {
                this._objectScriptingValidator.validate("groovy", script);
            }
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            if (portalException instanceof ObjectScriptingException) {
                ObjectScriptingException objectScriptingException = (ObjectScriptingException)((Object)portalException);
                throw new ObjectValidationRuleScriptException(objectScriptingException.getMessageKey());
            }
            throw new ObjectValidationRuleScriptException("syntax-error");
        }
    }
}

