/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationCategory;
import com.liferay.frontend.taglib.servlet.taglib.ScreenNavigationEntry;
import com.liferay.object.internal.layout.tab.screen.navigation.category.ObjectLayoutTabScreenNavigationCategory;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.service.base.ObjectLayoutTabLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectLayoutTab"}, service={AopService.class})
public class ObjectLayoutTabLocalServiceImpl
extends ObjectLayoutTabLocalServiceBaseImpl {
    private BundleContext _bundleContext;
    private final Map<String, ServiceRegistration<?>> _serviceRegistrations = new ConcurrentHashMap();
    @Reference
    private UserLocalService _userLocalService;

    public ObjectLayoutTab addObjectLayoutTab(long userId, long objectLayoutId, long objectRelationshipId, Map<Locale, String> nameMap, int priority) throws PortalException {
        ObjectLayoutTab objectLayoutTab = this.objectLayoutTabPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectLayoutTab.setCompanyId(user.getCompanyId());
        objectLayoutTab.setUserId(user.getUserId());
        objectLayoutTab.setUserName(user.getFullName());
        objectLayoutTab.setObjectLayoutId(objectLayoutId);
        objectLayoutTab.setObjectRelationshipId(objectRelationshipId);
        objectLayoutTab.setNameMap(nameMap);
        objectLayoutTab.setPriority(priority);
        return (ObjectLayoutTab)this.objectLayoutTabPersistence.update((BaseModel)objectLayoutTab);
    }

    public void deleteObjectLayoutObjectLayoutTabs(long objectLayoutId) throws PortalException {
        for (ObjectLayoutTab objectLayoutTab : this.objectLayoutTabPersistence.findByObjectLayoutId(objectLayoutId)) {
            this.deleteObjectLayoutTab(objectLayoutTab);
        }
    }

    @Override
    public ObjectLayoutTab deleteObjectLayoutTab(long objectLayoutTabId) throws PortalException {
        ObjectLayoutTab objectLayoutTab = this.objectLayoutTabPersistence.findByPrimaryKey(objectLayoutTabId);
        return this.deleteObjectLayoutTab(objectLayoutTab);
    }

    @Override
    public ObjectLayoutTab deleteObjectLayoutTab(ObjectLayoutTab objectLayoutTab) {
        this.objectLayoutTabPersistence.remove((BaseModel)objectLayoutTab);
        ServiceRegistration<?> serviceRegistration = this._serviceRegistrations.get(this._getServiceRegistrationKey(objectLayoutTab));
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            this._serviceRegistrations.remove(this._getServiceRegistrationKey(objectLayoutTab));
        }
        return objectLayoutTab;
    }

    public void deleteObjectRelationshipObjectLayoutTabs(long objectRelationshipId) throws PortalException {
        for (ObjectLayoutTab objectLayoutTab : this.objectLayoutTabPersistence.findByObjectRelationshipId(objectRelationshipId)) {
            this.deleteObjectLayoutTab(objectLayoutTab);
        }
    }

    public List<ObjectLayoutTab> getObjectLayoutObjectLayoutTabs(long objectLayoutId) {
        return this.objectLayoutTabPersistence.findByObjectLayoutId(objectLayoutId);
    }

    public void registerObjectLayoutTabScreenNavigationCategories(ObjectDefinition objectDefinition, List<ObjectLayoutTab> objectLayoutTabs) {
        for (int i = objectLayoutTabs.size() - 1; i >= 0; --i) {
            ObjectLayoutTab objectLayoutTab = objectLayoutTabs.get(i);
            this._serviceRegistrations.computeIfAbsent(this._getServiceRegistrationKey(objectLayoutTab), serviceRegistrationKey -> this._bundleContext.registerService(new String[]{ScreenNavigationCategory.class.getName(), ScreenNavigationEntry.class.getName()}, (Object)new ObjectLayoutTabScreenNavigationCategory(objectDefinition, objectLayoutTab), (Dictionary)HashMapDictionaryBuilder.put((Object)"screen.navigation.category.order:Integer", (Object)objectLayoutTab.getObjectLayoutTabId()).put((Object)"screen.navigation.entry.order:Integer", (Object)objectLayoutTab.getObjectLayoutId()).build()));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private String _getServiceRegistrationKey(ObjectLayoutTab objectLayoutTab) {
        return StringBundler.concat((Object[])new Object[]{objectLayoutTab.getCompanyId(), "#", objectLayoutTab.getObjectLayoutTabId()});
    }
}

