/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.object.exception.DuplicateObjectFieldExternalReferenceCodeException;
import com.liferay.object.exception.ObjectDefinitionEnableLocalizationException;
import com.liferay.object.exception.ObjectFieldBusinessTypeException;
import com.liferay.object.exception.ObjectFieldDBTypeException;
import com.liferay.object.exception.ObjectFieldLabelException;
import com.liferay.object.exception.ObjectFieldListTypeDefinitionIdException;
import com.liferay.object.exception.ObjectFieldLocalizedException;
import com.liferay.object.exception.ObjectFieldNameException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.ObjectFieldStateException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.internal.field.setting.contributor.ObjectFieldSettingContributor;
import com.liferay.object.internal.field.setting.contributor.ObjectFieldSettingContributorRegistry;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectFieldLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldSettingPersistence;
import com.liferay.object.service.persistence.ObjectLayoutColumnPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectField"}, service={AopService.class})
public class ObjectFieldLocalServiceImpl
extends ObjectFieldLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFieldLocalServiceImpl.class);
    private final Map<String, String> _businessTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"PrecisionDecimal").put((Object)"Blob", (Object)"LargeFile").put((Object)"Boolean", (Object)"Boolean").put((Object)"Clob", (Object)"LongText").put((Object)"Date", (Object)"Date").put((Object)"Double", (Object)"Decimal").put((Object)"Integer", (Object)"Integer").put((Object)"Long", (Object)"LongInteger").put((Object)"String", (Object)"Text").build();
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectFieldSettingContributorRegistry _objectFieldSettingContributorRegistry;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectFieldSettingPersistence _objectFieldSettingPersistence;
    @Reference
    private ObjectLayoutColumnPersistence _objectLayoutColumnPersistence;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    private final Set<String> _reservedNames = SetUtil.fromArray((Object[])new String[]{"actions", "companyid", "createdate", "creator", "datecreated", "datemodified", "externalreferencecode", "groupid", "id", "lastpublishdate", "modifieddate", "status", "statusbyuserid", "statusbyusername", "statusdate", "userid", "username"});
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addCustomObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        name = StringUtil.trim((String)name);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        String dbTableName = objectDefinition.getDBTableName();
        if (objectDefinition.isApproved()) {
            dbTableName = objectDefinition.getExtensionDBTableName();
        }
        ObjectField objectField = this._addObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, name + "_", dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, required, state, false);
        if (objectDefinition.isApproved() && !objectField.compareBusinessType("Aggregation") && !objectField.compareBusinessType("Formula")) {
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableAddColumnSQL(dbTableName, objectField.getDBColumnName(), dbType));
        }
        this._addOrUpdateObjectFieldSettings(objectField, null, objectFieldSettings);
        return objectField;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addOrUpdateCustomObjectField(String externalReferenceCode, long objectFieldId, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField existingObjectField = null;
        if (objectFieldId > 0L) {
            existingObjectField = this.objectFieldPersistence.fetchByPrimaryKey(objectFieldId);
        }
        if (existingObjectField == null && Validator.isNotNull((String)externalReferenceCode)) {
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
            existingObjectField = this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
        }
        if (existingObjectField == null) {
            return this.objectFieldLocalService.addCustomObjectField(externalReferenceCode, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, required, state, objectFieldSettings);
        }
        return this.objectFieldLocalService.updateCustomObjectField(externalReferenceCode, existingObjectField.getObjectFieldId(), listTypeDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, required, state, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addOrUpdateSystemObjectField(long userId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, boolean state) throws PortalException {
        ObjectField existingObjectField = this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
        if (existingObjectField == null) {
            return this.addSystemObjectField(userId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required, state);
        }
        this._validateLabel(labelMap);
        existingObjectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)existingObjectField);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField addSystemObjectField(long userId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, String name, boolean required, boolean state) throws PortalException {
        name = StringUtil.trim((String)name);
        if (Validator.isNull((String)dbColumnName)) {
            dbColumnName = name;
        }
        return this._addObjectField(null, userId, 0L, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, false, name, required, state, true);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        return this.deleteObjectField(objectField);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectField deleteObjectField(ObjectField objectField) throws PortalException {
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it has a relationship type");
        }
        return this._deleteObjectField(objectField);
    }

    public void deleteObjectFieldByObjectDefinitionId(Long objectDefinitionId) throws PortalException {
        for (ObjectField objectField : this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            if (Validator.isNotNull((String)objectField.getRelationshipType())) continue;
            this.objectFieldPersistence.remove((BaseModel)objectField);
            this._objectFieldSettingLocalService.deleteObjectFieldObjectFieldSetting(objectField);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectField deleteRelationshipTypeObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        if (Validator.isNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be deleted because it does not have a relationship type");
        }
        return this._deleteObjectField(objectField);
    }

    public ObjectField fetchObjectField(long objectDefinitionId, String name) {
        return this.objectFieldPersistence.fetchByODI_N(objectDefinitionId, name);
    }

    public ObjectField fetchObjectField(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    public List<ObjectField> getActiveObjectFields(List<ObjectField> objectFields) throws PortalException {
        ArrayList<ObjectField> activeObjectFields = new ArrayList<ObjectField>();
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
            if (Validator.isNotNull((String)objectField.getRelationshipType())) {
                ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectField.getObjectFieldId());
                ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
                if (!objectDefinition.isActive()) continue;
                activeObjectFields.add(objectField);
                continue;
            }
            activeObjectFields.add(objectField);
        }
        return activeObjectFields;
    }

    public Column<?, ?> getColumn(long objectDefinitionId, String name) {
        try {
            ObjectField objectField = this.fetchObjectField(objectDefinitionId, name);
            if (objectField == null && (objectField = this._getObjectRelationshipField(objectDefinitionId, name)) == null) {
                throw new UnsupportedOperationException("Unsupported method getColumn with field name " + name);
            }
            if (Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(objectField.getBusinessType(), "RichText")) {
                throw new UnsupportedOperationException("Unsupported operation with " + objectField.getBusinessType() + " field");
            }
            Table table = this.getTable(objectDefinitionId, objectField.getName());
            return table.getColumn(objectField.getDBColumnName());
        }
        catch (PortalException portalException) {
            return (Column)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public List<ObjectField> getCustomObjectFields(long objectFieldId) {
        List objectFields = this.objectFieldPersistence.findByODI_S(objectFieldId, false);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public List<ObjectField> getListTypeDefinitionObjectFields(long listTypeDefinitionId, boolean state) {
        return this.objectFieldPersistence.findByLTDI_S(listTypeDefinitionId, state);
    }

    @Override
    public ObjectField getObjectField(long objectFieldId) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        return objectField;
    }

    public ObjectField getObjectField(long objectDefinitionId, String name) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByODI_N(objectDefinitionId, name);
        objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        return objectField;
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId) {
        List objectFields = this.objectFieldPersistence.findByObjectDefinitionId(objectDefinitionId);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, boolean system) {
        List objectFields = this.objectFieldPersistence.findByODI_S(objectDefinitionId, system);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public List<ObjectField> getObjectFields(long objectDefinitionId, String dbTableName) {
        List objectFields = this.objectFieldPersistence.findByODI_DTN(objectDefinitionId, dbTableName);
        for (ObjectField objectField : objectFields) {
            objectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()));
        }
        return objectFields;
    }

    public int getObjectFieldsCount(long objectDefinitionId) {
        return this.objectFieldPersistence.countByObjectDefinitionId(objectDefinitionId);
    }

    public int getObjectFieldsCountByListTypeDefinitionId(long listTypeDefinitionId) {
        return this.objectFieldPersistence.countByListTypeDefinitionId(listTypeDefinitionId);
    }

    public Table getTable(long objectDefinitionId, String name) throws PortalException {
        ObjectField objectField = this.getObjectField(objectDefinitionId, name);
        if (Objects.equals(objectField.getDBTableName(), ObjectEntryTable.INSTANCE.getTableName())) {
            return ObjectEntryTable.INSTANCE;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (Objects.equals(objectField.getDBTableName(), objectDefinition.getDBTableName())) {
            return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
        }
        return new DynamicObjectDefinitionTable(objectDefinition, this.objectFieldLocalService.getObjectFields(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateCustomObjectField(String externalReferenceCode, long objectFieldId, long listTypeDefinitionId, String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, boolean required, boolean state, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectField oldObjectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        ObjectField newObjectField = (ObjectField)oldObjectField.clone();
        this._validateExternalReferenceCode(externalReferenceCode, newObjectField.getObjectFieldId(), newObjectField.getCompanyId(), newObjectField.getObjectDefinitionId());
        this._validateListTypeDefinitionId(listTypeDefinitionId, businessType);
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap);
        this._validateLocalized(businessType, localized, oldObjectField.getObjectDefinition());
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(newObjectField.getObjectDefinitionId());
        if (Validator.isNotNull((String)newObjectField.getRelationshipType())) {
            this._validateObjectRelationshipDeletionType(objectFieldId, required);
            newObjectField.setRequired(required);
            if (!Objects.equals(newObjectField.getDBType(), dbType) || !Objects.equals(newObjectField.getName(), name)) {
                throw new ObjectFieldRelationshipTypeException("Object field relationship name and DB type cannot be changed");
            }
        } else {
            this._validateName(objectFieldId, objectDefinition, name, false);
        }
        this._validateState(required, state);
        newObjectField.setExternalReferenceCode(externalReferenceCode);
        newObjectField.setIndexed(indexed);
        newObjectField.setIndexedAsKeyword(indexedAsKeyword);
        newObjectField.setIndexedLanguageId(indexedLanguageId);
        newObjectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        if (objectDefinition.isApproved()) {
            newObjectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)newObjectField);
            this._addOrUpdateObjectFieldSettings(newObjectField, oldObjectField, objectFieldSettings);
            return newObjectField;
        }
        this._setBusinessTypeAndDBType(businessType, dbType, newObjectField);
        newObjectField.setListTypeDefinitionId(listTypeDefinitionId);
        newObjectField.setDBColumnName(name + "_");
        newObjectField.setLocalized(localized);
        newObjectField.setName(name);
        newObjectField.setRequired(required);
        newObjectField.setState(state);
        newObjectField = (ObjectField)this.objectFieldPersistence.update((BaseModel)newObjectField);
        this._addOrUpdateObjectFieldSettings(newObjectField, oldObjectField, objectFieldSettings);
        return newObjectField;
    }

    public ObjectField updateObjectField(String externalReferenceCode, long objectFieldId, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, boolean required, boolean state, boolean system, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        if (system) {
            return this.objectFieldLocalService.addOrUpdateSystemObjectField(userId, objectDefinitionId, businessType, dbColumnName, dbTableName, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, name, required, state);
        }
        return this.objectFieldLocalService.addOrUpdateCustomObjectField(externalReferenceCode, objectFieldId, userId, listTypeDefinitionId, objectDefinitionId, businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId, labelMap, localized, name, required, state, objectFieldSettings);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectField updateRequired(long objectFieldId, boolean required) throws PortalException {
        ObjectField objectField = this.objectFieldPersistence.findByPrimaryKey(objectFieldId);
        if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) {
            this._validateObjectRelationshipDeletionType(objectFieldId, required);
        }
        objectField.setRequired(required);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    private ObjectField _addObjectField(String externalReferenceCode, long userId, long listTypeDefinitionId, long objectDefinitionId, String businessType, String dbColumnName, String dbTableName, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId, Map<Locale, String> labelMap, boolean localized, String name, boolean required, boolean state, boolean system) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateExternalReferenceCode(externalReferenceCode, 0L, objectDefinition.getCompanyId(), objectDefinitionId);
        this._validateListTypeDefinitionId(listTypeDefinitionId, businessType);
        this._validateIndexed(businessType, dbType, indexed, indexedAsKeyword, indexedLanguageId);
        this._validateLabel(labelMap);
        this._validateLocalized(businessType, localized, objectDefinition);
        this._validateName(0L, objectDefinition, name, system);
        this._validateState(required, state);
        ObjectField objectField = this.objectFieldPersistence.create(this.counterLocalService.increment());
        objectField.setExternalReferenceCode(externalReferenceCode);
        this._setBusinessTypeAndDBType(businessType, dbType, objectField);
        User user = this._userLocalService.getUser(userId);
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(listTypeDefinitionId);
        objectField.setObjectDefinitionId(objectDefinitionId);
        objectField.setDBColumnName(dbColumnName);
        objectField.setDBTableName(dbTableName);
        objectField.setIndexed(indexed);
        objectField.setIndexedAsKeyword(indexedAsKeyword);
        objectField.setIndexedLanguageId(indexedLanguageId);
        objectField.setLocalized(localized);
        objectField.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectField.setName(name);
        objectField.setRelationshipType(null);
        objectField.setRequired(required);
        objectField.setState(state);
        objectField.setSystem(system);
        return (ObjectField)this.objectFieldPersistence.update((BaseModel)objectField);
    }

    private void _addOrUpdateObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(newObjectField.getBusinessType());
        objectFieldBusinessType.validateObjectFieldSettings(newObjectField, objectFieldSettings);
        for (ObjectFieldSetting oldObjectFieldSetting : this._objectFieldSettingPersistence.findByObjectFieldId(newObjectField.getObjectFieldId())) {
            ObjectFieldSetting objectFieldSetting = null;
            for (ObjectFieldSetting newObjectFieldSetting : objectFieldSettings) {
                if (!Objects.equals(oldObjectFieldSetting.getName(), newObjectFieldSetting.getName())) continue;
                objectFieldSetting = newObjectFieldSetting;
                break;
            }
            if (objectFieldSetting != null) continue;
            this._objectFieldSettingLocalService.deleteObjectFieldSetting(oldObjectFieldSetting.getObjectFieldSettingId());
        }
        objectFieldBusinessType.predefineObjectFieldSettings(newObjectField, oldObjectField, objectFieldSettings);
        for (ObjectFieldSetting newObjectFieldSetting : objectFieldSettings) {
            ObjectFieldSetting oldObjectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(newObjectField.getObjectFieldId(), newObjectFieldSetting.getName());
            ObjectFieldSettingContributor objectFieldSettingContributor = this._objectFieldSettingContributorRegistry.getObjectFieldSettingContributor(newObjectFieldSetting.getName());
            if (oldObjectFieldSetting == null) {
                objectFieldSettingContributor.addObjectFieldSetting(newObjectField.getUserId(), newObjectField.getObjectFieldId(), newObjectFieldSetting);
                continue;
            }
            objectFieldSettingContributor.updateObjectFieldSetting(oldObjectFieldSetting.getObjectFieldSettingId(), newObjectFieldSetting);
        }
        newObjectField.setObjectFieldSettings(this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(newObjectField.getObjectFieldId()));
    }

    private void _alterTableDropColumn(String tableName, String columnName) {
        try {
            Connection connection = this._currentConnection.getConnection(this.objectFieldPersistence.getDataSource());
            DB db = this.objectFieldPersistence.getDB();
            db.alterTableDropColumn(connection, tableName, columnName);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private ObjectField _deleteObjectField(ObjectField objectField) throws PortalException {
        ObjectFieldSetting objectFieldSetting;
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectField.getObjectDefinitionId());
        if ((objectDefinition.isApproved() || objectDefinition.isSystem()) && !Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName()) && !Objects.equals(objectField.getBusinessType(), "Relationship")) {
            throw new RequiredObjectFieldException();
        }
        if (Objects.equals(objectField.getBusinessType(), "Attachment") && Objects.equals((objectFieldSetting = this._objectFieldSettingPersistence.fetchByOFI_N(objectField.getObjectFieldId(), "fileSource")).getValue(), "userComputer")) {
            List objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectField.getObjectDefinitionId());
            for (ObjectEntry objectEntry : objectEntries) {
                Map values = objectEntry.getValues();
                try {
                    this._dlFileEntryLocalService.deleteFileEntry(GetterUtil.getLong(values.get(objectField.getName())));
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)portalException);
                }
            }
        }
        objectField = (ObjectField)this.objectFieldPersistence.remove((BaseModel)objectField);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() == objectField.getObjectFieldId()) {
            objectDefinition.setAccountEntryRestrictedObjectFieldId(0L);
            objectDefinition.setAccountEntryRestricted(false);
            objectDefinition = (ObjectDefinition)this._objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        this._objectFieldSettingLocalService.deleteObjectFieldObjectFieldSetting(objectField);
        this._objectLayoutColumnPersistence.removeByObjectFieldId(objectField.getObjectFieldId());
        if (objectField.isState()) {
            this._objectStateFlowLocalService.deleteObjectFieldObjectStateFlow(objectField.getObjectFieldId());
        }
        this._objectViewLocalService.unassociateObjectField(objectField);
        if ((Objects.equals(objectDefinition.getExtensionDBTableName(), objectField.getDBTableName()) || objectDefinition.isApproved() && Objects.equals(objectField.getBusinessType(), "Relationship")) && !objectField.compareBusinessType("Aggregation") && !objectField.compareBusinessType("Formula")) {
            this._alterTableDropColumn(objectField.getDBTableName(), objectField.getDBColumnName());
        }
        return objectField;
    }

    private ObjectField _getObjectRelationshipField(long objectDefinitionId, String relationshipIdName) {
        for (ObjectField objectField : this.getObjectFields(objectDefinitionId)) {
            if (!StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship") || !StringUtil.endsWith((String)objectField.getName(), (String)("_" + relationshipIdName))) continue;
            return objectField;
        }
        return null;
    }

    private void _setBusinessTypeAndDBType(String businessType, String dbType, ObjectField objectField) throws PortalException {
        ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(GetterUtil.getString((String)businessType));
        Set objectFieldDBTypes = this._objectFieldBusinessTypeRegistry.getObjectFieldDBTypes();
        if (objectFieldBusinessType != null) {
            objectField.setBusinessType(businessType);
            objectField.setDBType(objectFieldBusinessType.getDBType());
        } else if (objectFieldDBTypes.contains(dbType) && this._businessTypes.containsKey(dbType)) {
            objectField.setBusinessType(this._businessTypes.get(dbType));
            objectField.setDBType(dbType);
        } else {
            if (!businessType.isEmpty()) {
                throw new ObjectFieldBusinessTypeException("Invalid business type " + businessType);
            }
            throw new ObjectFieldDBTypeException("Invalid DB type " + dbType);
        }
    }

    private void _validateExternalReferenceCode(String externalReferenceCode, long objectFieldId, long companyId, long objectDefinitionId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new DuplicateObjectFieldExternalReferenceCodeException();
        }
    }

    private void _validateIndexed(String businessType, String dbType, boolean indexed, boolean indexedAsKeyword, String indexedLanguageId) throws PortalException {
        if (indexed && Objects.equals(dbType, "Blob")) {
            throw new ObjectFieldDBTypeException("Blob type is not indexable");
        }
        if (!((Objects.equals(businessType, "Attachment") || Objects.equals(dbType, "Clob") || Objects.equals(dbType, "String")) && !indexedAsKeyword || Validator.isBlank((String)indexedLanguageId))) {
            throw new ObjectFieldDBTypeException("Indexed language ID can only be applied with type \"Clob\" or \"String\" that is not indexed as a keyword");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectFieldLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateListTypeDefinitionId(long listTypeDefinitionId, String businessType) throws PortalException {
        if (listTypeDefinitionId == 0L && (StringUtil.equals((String)businessType, (String)"MultiselectPicklist") || StringUtil.equals((String)businessType, (String)"Picklist"))) {
            throw new ObjectFieldListTypeDefinitionIdException("List type definition ID is 0");
        }
    }

    private void _validateLocalized(String businessType, boolean localized, ObjectDefinition objectDefinition) throws PortalException {
        if (!localized) {
            return;
        }
        if (!(businessType.equals("LongText") || businessType.equals("RichText") || businessType.equals("Text"))) {
            throw new ObjectFieldLocalizedException(StringBundler.concat((String[])new String[]{"Only ", "LongText", ",", "RichText", " and ", "Text", " business types support localization"}));
        }
        if (!objectDefinition.isEnableLocalization()) {
            throw new ObjectDefinitionEnableLocalizationException();
        }
    }

    private void _validateName(long objectFieldId, ObjectDefinition objectDefinition, String name, boolean system) throws PortalException {
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectFieldNameException.MustNotBeNull();
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectFieldNameException.MustOnlyContainLettersAndDigits();
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectFieldNameException.MustBeginWithLowerCaseLetter();
        }
        if (nameCharArray.length > 41) {
            throw new ObjectFieldNameException.MustBeLessThan41Characters();
        }
        if (!system && this._reservedNames.contains(StringUtil.toLowerCase((String)name)) || StringUtil.equalsIgnoreCase((String)objectDefinition.getPKObjectFieldName(), (String)name)) {
            throw new ObjectFieldNameException.MustNotBeReserved(name);
        }
        ObjectField objectField = this.objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), name);
        if (objectField != null && objectField.getObjectFieldId() != objectFieldId) {
            throw new ObjectFieldNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectRelationshipDeletionType(long objectFieldId, boolean required) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId);
        if (StringUtil.equals((String)objectRelationship.getDeletionType(), (String)"disassociate") && required) {
            throw new ObjectFieldRelationshipTypeException("Object field cannot be required because the relationship deletion type is disassociate");
        }
    }

    private void _validateState(boolean required, boolean state) throws PortalException {
        if (state && !required) {
            throw new ObjectFieldStateException("Object field must be required when the state is true");
        }
    }
}

