/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.exception.ObjectEntryCountException;
import com.liferay.object.internal.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectEntryServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntry"}, service={AopService.class})
public class ObjectEntryServiceImpl
extends ObjectEntryServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    private volatile ServiceTrackerMap<String, PortletResourcePermission> _portletResourcePermissionsServiceTrackerMap;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public ObjectEntry addObjectEntry(long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY", values);
        }
        this._validateSubmissionLimit(objectDefinitionId, this.getUser());
        return this.objectEntryLocalService.addObjectEntry(this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByERC_C_ODI(externalReferenceCode, serviceContext.getCompanyId(), objectDefinitionId);
        if (objectEntry == null) {
            this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY", values);
        } else {
            this.checkModelResourcePermission(objectDefinitionId, objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.addOrUpdateObjectEntry(externalReferenceCode, this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public void checkModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        modelResourcePermission.check(this.getPermissionChecker(), objectEntryId, actionId);
    }

    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        this._checkPermission("DELETE", this.objectEntryLocalService.getObjectEntry(objectEntryId));
        return this.objectEntryLocalService.deleteObjectEntry(objectEntryId);
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        this._checkPermission("DELETE", objectEntry);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public ObjectEntry fetchObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            this._checkPermission("VIEW", objectEntry);
        }
        return objectEntry;
    }

    public List<ObjectEntry> getManyToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getManyToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, reverse, start, end);
        for (ObjectEntry objectEntry : objectEntries) {
            this.objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntries;
    }

    public int getManyToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related, boolean reverse) throws PortalException {
        return this.objectEntryLocalService.getManyToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related, reverse);
    }

    public ModelResourcePermission<ObjectEntry> getModelResourcePermission(ObjectEntry objectEntry) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        return ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
    }

    public ObjectEntry getObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPermission("VIEW", objectEntry);
        }
        return objectEntry;
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, groupId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this._checkPermission("VIEW", objectEntry);
        }
        return objectEntry;
    }

    public List<ObjectEntry> getOneToManyObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean related, int start, int end) throws PortalException {
        List objectEntries = this.objectEntryLocalService.getOneToManyObjectEntries(groupId, objectRelationshipId, primaryKey, related, start, end);
        for (ObjectEntry objectEntry : objectEntries) {
            this.objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntries;
    }

    public int getOneToManyObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean related) throws PortalException {
        return this.objectEntryLocalService.getOneToManyObjectEntriesCount(groupId, objectRelationshipId, primaryKey, related);
    }

    public boolean hasModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        return modelResourcePermission.contains(this.getPermissionChecker(), objectEntryId, actionId);
    }

    public boolean hasModelResourcePermission(ObjectEntry objectEntry, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        return modelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)objectEntry, actionId);
    }

    public boolean hasModelResourcePermission(User user, long objectEntryId, String actionId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
        return modelResourcePermission.contains(permissionChecker, objectEntryId, actionId);
    }

    public boolean hasPortletResourcePermission(long groupId, long objectDefinitionId, String actionId) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._getPortletResourcePermission(objectDefinitionId);
        return portletResourcePermission.contains(this.getPermissionChecker(), groupId, actionId);
    }

    public ObjectEntry updateObjectEntry(long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        if (!ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission()) {
            this.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.updateObjectEntry(this.getUserId(), objectEntryId, values, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
        this._portletResourcePermissionsServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortletResourcePermission.class, (String)"(&(com.liferay.object=true)(resource.name=*))", (serviceReference, emitter) -> emitter.emit((Object)((String)serviceReference.getProperty("resource.name"))));
    }

    @Override
    @Deactivate
    protected void deactivate() {
        this._portletResourcePermissionsServiceTrackerMap.close();
    }

    private void _checkPermission(String actionId, ObjectEntry objectEntry) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
        modelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)objectEntry, actionId);
    }

    private void _checkPortletResourcePermission(long groupId, long objectDefinitionId, String actionId, Map<String, Serializable> values) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._getPortletResourcePermission(objectDefinitionId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        portletResourcePermission.check(permissionChecker, groupId, actionId);
        if (permissionChecker.hasPermission(groupId, portletResourcePermission.getResourceName(), 0L, actionId)) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (!objectDefinition.isAccountEntryRestricted()) {
            return;
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        long accountEntryId = MapUtil.getLong(values, (String)objectField.getName());
        if (accountEntryId == 0L) {
            return;
        }
        long[] accountEntryIds = ListUtil.toLongArray((List)this._accountEntryLocalService.getUserAccountEntries(this.getUserId(), Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1), AccountEntryModel::getAccountEntryId);
        if (!ArrayUtil.contains((long[])accountEntryIds, (long)accountEntryId)) {
            throw new ObjectDefinitionAccountEntryRestrictedException(StringBundler.concat((Object[])new Object[]{"User ", this.getUserId(), " does not have access to account entry ", accountEntryId}));
        }
        HashSet rolesIds = new HashSet();
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId()), UserGroupRoleModel::getRoleId));
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            Group group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), organization.getOrganizationId());
            rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            for (Organization ancestorOrganization : organization.getAncestors()) {
                group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), ancestorOrganization.getOrganizationId());
                rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            }
        }
        for (Long roleId : rolesIds) {
            ResourcePermission resourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(objectDefinition.getCompanyId(), objectDefinition.getResourceName(), 3, "0", roleId.longValue());
            if (resourcePermission == null || !resourcePermission.hasActionId(actionId)) continue;
            return;
        }
        throw new PrincipalException.MustHavePermission(permissionChecker, objectDefinition.getResourceName(), 0L, new String[]{actionId});
    }

    private PortletResourcePermission _getPortletResourcePermission(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return (PortletResourcePermission)this._portletResourcePermissionsServiceTrackerMap.getService((Object)objectDefinition.getResourceName());
    }

    private void _validateSubmissionLimit(long objectDefinitionId, User user) throws PortalException {
        long maximumNumberOfGuestUserObjectEntriesPerObjectDefinition;
        if (!user.isDefaultUser()) {
            return;
        }
        int count = this.objectEntryPersistence.countByU_ODI(user.getUserId(), objectDefinitionId);
        if ((long)count >= (maximumNumberOfGuestUserObjectEntriesPerObjectDefinition = (long)this._objectConfiguration.maximumNumberOfGuestUserObjectEntriesPerObjectDefinition())) {
            throw new ObjectEntryCountException(StringBundler.concat((Object[])new Object[]{"Unable to exceed ", maximumNumberOfGuestUserObjectEntriesPerObjectDefinition, " guest object entries for object definition ", objectDefinitionId}));
        }
    }
}

