/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedObjectFieldIdException;
import com.liferay.object.exception.ObjectDefinitionActiveException;
import com.liferay.object.exception.ObjectDefinitionEnableCategorizationException;
import com.liferay.object.exception.ObjectDefinitionEnableCommentsException;
import com.liferay.object.exception.ObjectDefinitionEnableObjectEntryHistoryException;
import com.liferay.object.exception.ObjectDefinitionLabelException;
import com.liferay.object.exception.ObjectDefinitionNameException;
import com.liferay.object.exception.ObjectDefinitionPluralLabelException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectDefinitionStatusException;
import com.liferay.object.exception.ObjectDefinitionVersionException;
import com.liferay.object.exception.ObjectFieldRelationshipTypeException;
import com.liferay.object.exception.RequiredObjectDefinitionException;
import com.liferay.object.exception.RequiredObjectFieldException;
import com.liferay.object.internal.deployer.ObjectDefinitionDeployerImpl;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.impl.ObjectDefinitionImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.ObjectLayoutTabLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.object.service.base.ObjectDefinitionLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchRegistrarHelper;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"model.class.name=com.liferay.object.model.ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionLocalServiceImpl
extends ObjectDefinitionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionLocalServiceImpl.class);
    private static final MethodKey _deployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "deployObjectDefinition", new Class[]{ObjectDefinition.class});
    private static final MethodKey _undeployObjectDefinitionMethodKey = new MethodKey(ObjectDefinitionLocalServiceUtil.class, "undeployObjectDefinition", new Class[]{ObjectDefinition.class});
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    private BundleContext _bundleContext;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Set<String> _defaultSystemObjectFieldNames = SetUtil.fromArray((Object[])new String[]{"creator", "createDate", "externalReferenceCode", "id", "modifiedDate", "status"});
    @Reference
    private DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private ModelSearchRegistrarHelper _modelSearchRegistrarHelper;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    private ServiceTracker<ObjectDefinitionDeployer, ObjectDefinitionDeployer> _objectDefinitionDeployerServiceTracker;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectEntryPersistence _objectEntryPersistence;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectLayoutLocalService _objectLayoutLocalService;
    @Reference
    private ObjectLayoutTabLocalService _objectLayoutTabLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectViewLocalService _objectViewLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private PLOEntryLocalService _ploEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourceActions _resourceActions;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    private final Map<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> _serviceRegistrationsMaps = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    private ModelPreFilterContributor _workflowStatusModelPreFilterContributor;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addCustomObjectDefinition(long userId, boolean enableComments, boolean enableLocalization, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope, String storageType, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, null, null, enableComments, enableLocalization, labelMap, true, name, panelAppOrder, panelCategoryKey, null, null, pluralLabelMap, scope, storageType, false, null, 0, 2, objectFields);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addObjectDefinition(String externalReferenceCode, long userId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        User user = this._userLocalService.getUser(userId);
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setActive(false);
        objectDefinition.setLabel(externalReferenceCode);
        objectDefinition.setModifiable(true);
        objectDefinition.setName(externalReferenceCode);
        objectDefinition.setPluralLabel(externalReferenceCode);
        objectDefinition.setScope("company");
        objectDefinition.setStorageType("default");
        objectDefinition.setSystem(false);
        objectDefinition.setStatus(2);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        this._addSystemObjectFields(ObjectEntryTable.INSTANCE.getTableName(), objectDefinition, ObjectEntryTable.INSTANCE.objectEntryId.getName(), userId);
        return this._updateTitleObjectFieldId(objectDefinition, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addOrUpdateSystemObjectDefinition(long companyId, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, systemObjectDefinitionMetadata.getName());
        long userId = this._userLocalService.getDefaultUserId(companyId);
        if (objectDefinition == null) {
            Table table = systemObjectDefinitionMetadata.getTable();
            Column primaryKeyColumn = systemObjectDefinitionMetadata.getPrimaryKeyColumn();
            return this.addSystemObjectDefinition(userId, systemObjectDefinitionMetadata.getModelClassName(), table.getTableName(), false, systemObjectDefinitionMetadata.getLabelMap(), false, systemObjectDefinitionMetadata.getName(), null, null, primaryKeyColumn.getName(), primaryKeyColumn.getName(), systemObjectDefinitionMetadata.getPluralLabelMap(), systemObjectDefinitionMetadata.getScope(), systemObjectDefinitionMetadata.getTitleObjectFieldName(), systemObjectDefinitionMetadata.getVersion(), 0, systemObjectDefinitionMetadata.getObjectFields());
        }
        objectDefinition.setVersion(systemObjectDefinitionMetadata.getVersion());
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        List newObjectFields = systemObjectDefinitionMetadata.getObjectFields();
        List oldObjectFields = this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), objectDefinition.getDBTableName());
        for (ObjectField oldObjectField : oldObjectFields) {
            if (!oldObjectField.isSystem() || this._defaultSystemObjectFieldNames.contains(oldObjectField.getName()) || this._hasObjectField(newObjectFields, oldObjectField)) continue;
            this._objectFieldPersistence.remove((BaseModel)oldObjectField);
        }
        for (ObjectField newObjectField : newObjectFields) {
            ObjectField oldObjectField = this._objectFieldPersistence.fetchByODI_N(objectDefinition.getObjectDefinitionId(), newObjectField.getName());
            if (oldObjectField == null) {
                this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), newObjectField.getBusinessType(), newObjectField.getDBColumnName(), objectDefinition.getDBTableName(), newObjectField.getDBType(), false, false, "", newObjectField.getLabelMap(), newObjectField.getName(), newObjectField.isRequired(), newObjectField.isState());
                continue;
            }
            if (Objects.equals(oldObjectField.getDBType(), newObjectField.getDBType()) && Objects.equals(oldObjectField.isRequired(), newObjectField.isRequired())) continue;
            oldObjectField.setBusinessType(newObjectField.getBusinessType());
            oldObjectField.setDBType(newObjectField.getDBType());
            oldObjectField.setRequired(newObjectField.isRequired());
            this._objectFieldPersistence.update((BaseModel)oldObjectField);
        }
        return objectDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition addSystemObjectDefinition(long userId, String className, String dbTableName, boolean enableComments, Map<Locale, String> labelMap, boolean modifiable, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, String titleObjectFieldName, int version, int status, List<ObjectField> objectFields) throws PortalException {
        return this._addObjectDefinition(userId, className, dbTableName, false, enableComments, labelMap, modifiable, name, panelAppOrder, panelCategoryKey, pkObjectFieldDBColumnName, pkObjectFieldName, pluralLabelMap, scope, "default", true, titleObjectFieldName, version, status, objectFields);
    }

    public void deleteCompanyObjectDefinitions(long companyId) throws PortalException {
        List objectDefinitions = this.objectDefinitionPersistence.findByCompanyId(companyId);
        for (ObjectDefinition objectDefinition : objectDefinitions) {
            this.objectDefinitionLocalService.deleteObjectDefinition(objectDefinition);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this.deleteObjectDefinition(objectDefinition);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectDefinition deleteObjectDefinition(ObjectDefinition objectDefinition) throws PortalException {
        Object object;
        if (!PortalInstances.isCurrentCompanyInDeletionProcess() && !PortalRunMode.isTestMode() && objectDefinition.isSystem()) {
            throw new RequiredObjectDefinitionException();
        }
        this._objectActionLocalService.deleteObjectActions(objectDefinition.getObjectDefinitionId());
        if (!objectDefinition.isSystem()) {
            Iterator objectEntries = this._objectEntryPersistence.findByObjectDefinitionId(objectDefinition.getObjectDefinitionId());
            object = objectEntries.iterator();
            while (object.hasNext()) {
                ObjectEntry objectEntry = (ObjectEntry)object.next();
                this._objectEntryLocalService.deleteObjectEntry(objectEntry);
            }
        }
        this._objectFieldLocalService.deleteObjectFieldByObjectDefinitionId(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectLayoutLocalService.deleteObjectLayouts(objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByODI1_R(objectDefinition.getObjectDefinitionId(), false)) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipPersistence.findByODI2_R(objectDefinition.getObjectDefinitionId(), false)) {
            this._objectRelationshipLocalService.deleteObjectRelationship(objectRelationship);
        }
        this._objectValidationRuleLocalService.deleteObjectValidationRules(Long.valueOf(objectDefinition.getObjectDefinitionId()));
        this._objectViewLocalService.deleteObjectViews(objectDefinition.getObjectDefinitionId());
        this.objectDefinitionPersistence.remove((BaseModel)objectDefinition);
        this._resourceLocalService.deleteResource(objectDefinition.getCompanyId(), ObjectDefinition.class.getName(), 4, objectDefinition.getObjectDefinitionId());
        if (objectDefinition.isSystem()) {
            this._dropTable(objectDefinition.getExtensionDBTableName());
        } else if (objectDefinition.isApproved()) {
            SafeCloseable safeCloseable = CompanyThreadLocal.lock((long)objectDefinition.getCompanyId());
            object = null;
            try {
                for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getClassName())) {
                    this._resourceActionLocalService.deleteResourceAction(resourceAction);
                }
                for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getPortletId())) {
                    this._resourceActionLocalService.deleteResourceAction(resourceAction);
                }
                for (ResourceAction resourceAction : this._resourceActionLocalService.getResourceActions(objectDefinition.getResourceName())) {
                    this._resourceActionLocalService.deleteResourceAction(resourceAction);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (safeCloseable != null) {
                    if (object != null) {
                        try {
                            safeCloseable.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        safeCloseable.close();
                    }
                }
            }
            this._dropTable(objectDefinition.getDBTableName());
            this._dropTable(objectDefinition.getExtensionDBTableName());
            this.undeployObjectDefinition(objectDefinition);
            this._registerTransactionCallbackForCluster(_undeployObjectDefinitionMethodKey, objectDefinition);
        }
        return objectDefinition;
    }

    public void deployObjectDefinition(ObjectDefinition objectDefinition) {
        this.undeployObjectDefinition(objectDefinition);
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            serviceRegistrationsMap.computeIfAbsent(objectDefinition.getObjectDefinitionId(), objectDefinitionId -> objectDefinitionDeployer.deploy(objectDefinition));
        }
    }

    public ObjectDefinition enableAccountEntryRestricted(ObjectRelationship objectRelationship) throws PortalException {
        ObjectDefinition objectDefinition1 = this.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (!Objects.equals(objectDefinition1.getShortName(), "AccountEntry")) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Custom object definitions can only be restricted by account entry");
        }
        ObjectDefinition objectDefinition2 = this.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
        if (objectDefinition2.isAccountEntryRestricted()) {
            return objectDefinition2;
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        objectDefinition2.setAccountEntryRestrictedObjectFieldId(objectField.getObjectFieldId());
        objectDefinition2.setAccountEntryRestricted(true);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition2);
    }

    public ObjectDefinition fetchObjectDefinition(long companyId, String name) {
        return this.objectDefinitionPersistence.fetchByC_N(companyId, name);
    }

    public ObjectDefinition fetchObjectDefinitionByClassName(long companyId, String className) {
        return this.objectDefinitionPersistence.fetchByC_C(companyId, className);
    }

    public ObjectDefinition fetchSystemObjectDefinition(String name) {
        for (ObjectDefinition systemObjectDefinition : this.getSystemObjectDefinitions()) {
            if (!Objects.equals(systemObjectDefinition.getName(), name)) continue;
            return systemObjectDefinition;
        }
        return null;
    }

    public List<ObjectDefinition> getCustomObjectDefinitions(int status) {
        return this.objectDefinitionPersistence.findByS_S(false, status);
    }

    @Override
    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        return this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, boolean system, int status) {
        return this.objectDefinitionPersistence.findByC_A_S_S(companyId, active, system, status);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, boolean active, int status) {
        return this.objectDefinitionPersistence.findByC_A_S(companyId, active, status);
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this.objectDefinitionPersistence.countByCompanyId(companyId);
    }

    public List<ObjectDefinition> getSystemObjectDefinitions() {
        return this.objectDefinitionPersistence.findBySystem(true);
    }

    public boolean hasObjectRelationship(long objectDefinitionId) {
        int countByObjectDefinitionId1 = this._objectRelationshipPersistence.countByObjectDefinitionId1(objectDefinitionId);
        int countByObjectDefinitionId2 = this._objectRelationshipPersistence.countByObjectDefinitionId2(objectDefinitionId);
        return countByObjectDefinitionId1 > 0 || countByObjectDefinitionId2 > 0;
    }

    public ObjectDefinition publishCustomObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isSystem()) {
            throw new ObjectDefinitionStatusException();
        }
        return this._publishObjectDefinition(userId, objectDefinition);
    }

    public ObjectDefinition publishSystemObjectDefinition(long userId, long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return this._publishObjectDefinition(userId, objectDefinition);
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        this._addingObjectDefinitionDeployer(new ObjectDefinitionDeployerImpl(this._accountEntryLocalService, this._accountEntryOrganizationRelLocalService, this._assetCategoryLocalService, this._assetTagLocalService, this._assetVocabularyLocalService, this._bundleContext, this._dynamicQueryBatchIndexingActionableFactory, this._groupLocalService, this._listTypeEntryLocalService, this._listTypeLocalService, this._modelSearchRegistrarHelper, this._objectActionLocalService, this, this._objectEntryLocalService, this._objectEntryManagerRegistry, this._objectEntryService, this._objectFieldLocalService, this._objectLayoutLocalService, this._objectLayoutTabLocalService, this._objectRelationshipLocalService, this._objectScopeProviderRegistry, this._objectViewLocalService, this._organizationLocalService, this._persistedModelLocalServiceRegistry, this._ploEntryLocalService, this._portletLocalService, this._resourceActions, this._userLocalService, this._resourcePermissionLocalService, this._workflowStatusModelPreFilterContributor, this._userGroupRoleLocalService));
        this._objectDefinitionDeployerServiceTracker = new ServiceTracker(this._bundleContext, ObjectDefinitionDeployer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ObjectDefinitionDeployer, ObjectDefinitionDeployer>(){

            public ObjectDefinitionDeployer addingService(ServiceReference<ObjectDefinitionDeployer> serviceReference) {
                return ObjectDefinitionLocalServiceImpl.this._addingObjectDefinitionDeployer((ObjectDefinitionDeployer)ObjectDefinitionLocalServiceImpl.this._bundleContext.getService(serviceReference));
            }

            public void modifiedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
            }

            public void removedService(ServiceReference<ObjectDefinitionDeployer> serviceReference, ObjectDefinitionDeployer objectDefinitionDeployer) {
                for (ObjectDefinition objectDefinition : ObjectDefinitionLocalServiceImpl.this._getObjectDefinitions()) {
                    objectDefinitionDeployer.undeploy(objectDefinition);
                }
                Map serviceRegistrationsMap = (Map)ObjectDefinitionLocalServiceImpl.this._serviceRegistrationsMaps.remove(objectDefinitionDeployer);
                for (List serviceRegistrations : serviceRegistrationsMap.values()) {
                    for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                        serviceRegistration.unregister();
                    }
                }
                ObjectDefinitionLocalServiceImpl.this._bundleContext.ungetService(serviceReference);
            }
        });
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            this._objectDefinitionDeployerServiceTracker.open();
            return null;
        });
    }

    public void undeployObjectDefinition(ObjectDefinition objectDefinition) {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            return;
        }
        for (Map.Entry<ObjectDefinitionDeployer, Map<Long, List<ServiceRegistration<?>>>> entry : this._serviceRegistrationsMaps.entrySet()) {
            ObjectDefinitionDeployer objectDefinitionDeployer = entry.getKey();
            objectDefinitionDeployer.undeploy(objectDefinition);
            Map<Long, List<ServiceRegistration<?>>> serviceRegistrationsMap = entry.getValue();
            List<ServiceRegistration<?>> serviceRegistrations = serviceRegistrationsMap.remove(objectDefinition.getObjectDefinitionId());
            if (serviceRegistrations == null) continue;
            for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                serviceRegistration.unregister();
            }
        }
        this._invalidatePortalCache(objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateCustomObjectDefinition(String externalReferenceCode, long objectDefinitionId, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, boolean enableCategorization, boolean enableComments, boolean enableLocalization, boolean enableObjectEntryHistory, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition.isUnmodifiableSystemObject()) {
            throw new ObjectDefinitionStatusException("Object definition " + objectDefinition);
        }
        return this._updateObjectDefinition(externalReferenceCode, objectDefinition, accountEntryRestrictedObjectFieldId, descriptionObjectFieldId, titleObjectFieldId, accountEntryRestricted, active, null, enableCategorization, enableComments, enableLocalization, enableObjectEntryHistory, labelMap, name, panelAppOrder, panelCategoryKey, portlet, null, null, pluralLabelMap, scope);
    }

    public ObjectDefinition updateExternalReferenceCode(long objectDefinitionId, String externalReferenceCode) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateSystemObjectDefinition(String externalReferenceCode, long objectDefinitionId, long titleObjectFieldId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectDefinition updateTitleObjectFieldId(long objectDefinitionId, long titleObjectFieldId) throws PortalException {
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        if (this._objectDefinitionDeployerServiceTracker != null) {
            this._objectDefinitionDeployerServiceTracker.close();
        }
    }

    private ObjectDefinitionDeployer _addingObjectDefinitionDeployer(ObjectDefinitionDeployer objectDefinitionDeployer) {
        ConcurrentHashMap<Long, List> serviceRegistrationsMap = new ConcurrentHashMap<Long, List>();
        for (ObjectDefinition objectDefinition : this._getObjectDefinitions()) {
            serviceRegistrationsMap.put(objectDefinition.getObjectDefinitionId(), objectDefinitionDeployer.deploy(objectDefinition));
        }
        this._serviceRegistrationsMaps.put(objectDefinitionDeployer, serviceRegistrationsMap);
        return objectDefinitionDeployer;
    }

    private ObjectDefinition _addObjectDefinition(long userId, String className, String dbTableName, boolean enableComments, boolean enableLocalization, Map<Locale, String> labelMap, boolean modifiable, String name, String panelAppOrder, String panelCategoryKey, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope, String storageType, boolean system, String titleObjectFieldName, int version, int status, List<ObjectField> objectFields) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        name = this._getName(name, modifiable, system);
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, modifiable, name, system, user.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, modifiable, system, shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, modifiable, system);
        storageType = Validator.isNotNull((String)storageType) ? storageType : "default";
        this._validateEnableComments(enableComments, modifiable, storageType, system);
        this._validateLabel(labelMap);
        this._validateName(0L, user.getCompanyId(), modifiable, name, system);
        this._validatePluralLabel(pluralLabelMap);
        this._validateScope(scope);
        this._validateVersion(system, version);
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.create(this.counterLocalService.increment());
        objectDefinition.setCompanyId(user.getCompanyId());
        objectDefinition.setUserId(user.getUserId());
        objectDefinition.setUserName(user.getFullName());
        objectDefinition.setActive(this._isUnmodifiableSystemObject(modifiable, system));
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setClassName(this._getClassName(objectDefinition.getObjectDefinitionId(), className, modifiable, system));
        objectDefinition.setEnableCategorization(!system && StringUtil.equals((String)storageType, (String)"default"));
        objectDefinition.setEnableComments(enableComments);
        objectDefinition.setEnableLocalization(enableLocalization);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setModifiable(modifiable);
        objectDefinition.setName(name);
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        objectDefinition.setScope(scope);
        objectDefinition.setStorageType(Validator.isNotNull((String)storageType) ? storageType : "default");
        objectDefinition.setSystem(system);
        objectDefinition.setVersion(version);
        objectDefinition.setStatus(status);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._resourceLocalService.addResources(objectDefinition.getCompanyId(), 0L, objectDefinition.getUserId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), false, true, true);
        if (objectDefinition.isModifiable() || !objectDefinition.isSystem()) {
            dbTableName = "ObjectEntry";
        }
        this._addSystemObjectFields(dbTableName, objectDefinition, pkObjectFieldName, userId);
        if (objectFields != null) {
            for (ObjectField objectField : objectFields) {
                if (objectDefinition.isUnmodifiableSystemObject() || objectField.isSystem()) {
                    this._objectFieldLocalService.addOrUpdateSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBColumnName(), objectDefinition.getDBTableName(), objectField.getDBType(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.getName(), objectField.isRequired(), objectField.isState());
                    continue;
                }
                this._objectFieldLocalService.addCustomObjectField(objectField.getExternalReferenceCode(), userId, objectField.getListTypeDefinitionId(), objectDefinition.getObjectDefinitionId(), objectField.getBusinessType(), objectField.getDBType(), objectField.isIndexed(), objectField.isIndexedAsKeyword(), objectField.getIndexedLanguageId(), objectField.getLabelMap(), objectField.isLocalized(), objectField.getName(), objectField.isRequired(), objectField.isState(), objectField.getObjectFieldSettings());
            }
        }
        if ((objectDefinition = this._updateTitleObjectFieldId(objectDefinition, titleObjectFieldName)).isUnmodifiableSystemObject()) {
            this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        }
        return objectDefinition;
    }

    private void _addSystemObjectFields(String dbTableName, ObjectDefinition objectDefinition, String pkObjectFieldName, long userId) throws PortalException {
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.userName.getName(), dbTableName, "String", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "author")), "creator", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.createDate.getName(), dbTableName, "Date", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "create-date")), "createDate", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.externalReferenceCode.getName(), dbTableName, "String", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "external-reference-code")), "externalReferenceCode", false, false);
        String dbColumnName = ObjectEntryTable.INSTANCE.objectEntryId.getName();
        if (objectDefinition.isUnmodifiableSystemObject()) {
            dbColumnName = pkObjectFieldName;
        }
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "LongInteger", dbColumnName, dbTableName, "Long", true, true, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "id")), "id", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Date", ObjectEntryTable.INSTANCE.modifiedDate.getName(), dbTableName, "Date", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "modified-date")), "modifiedDate", false, false);
        this._objectFieldLocalService.addSystemObjectField(userId, objectDefinition.getObjectDefinitionId(), "Text", ObjectEntryTable.INSTANCE.status.getName(), dbTableName, "Integer", false, false, null, LocalizedMapUtil.getLocalizedMap((String)this._language.get(LocaleUtil.getDefault(), "status")), "status", false, false);
    }

    private void _createTable(String dbTableName, ObjectDefinition objectDefinition) {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinition.getObjectDefinitionId(), dbTableName), dbTableName);
        this.runSQL(dynamicObjectDefinitionTable.getCreateTableSQL());
    }

    private void _dropTable(String dbTableName) {
        String sql = "drop table " + dbTableName;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        this.runSQL(sql);
    }

    private String _getClassName(long objectDefinitionId, String className, boolean modifiable, boolean system) {
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return className;
        }
        return ObjectDefinition.class.getName() + "#" + objectDefinitionId;
    }

    private String _getDBTableName(String dbTableName, boolean modifiable, String name, boolean system, Long companyId, String shortName) {
        if (Validator.isNotNull((String)dbTableName)) {
            return dbTableName;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return name;
        }
        return StringBundler.concat((Object[])new Object[]{"O_", companyId, "_", shortName});
    }

    private String _getName(String name, boolean modifiable, boolean system) {
        name = StringUtil.trim((String)name);
        if (modifiable || !system) {
            name = "C_" + name;
        }
        return name;
    }

    private List<ObjectDefinition> _getObjectDefinitions() {
        ArrayList<ObjectDefinition> objectDefinitions = new ArrayList<ObjectDefinition>();
        this._companyLocalService.forEachCompanyId(companyId -> objectDefinitions.addAll(this.objectDefinitionLocalService.getObjectDefinitions(companyId.longValue(), true, 0)));
        return objectDefinitions;
    }

    private String _getPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName, String pkObjectFieldName, boolean modifiable, boolean system) {
        if (Validator.isNotNull((String)pkObjectFieldDBColumnName)) {
            return pkObjectFieldDBColumnName;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return pkObjectFieldName;
        }
        return pkObjectFieldName + "_";
    }

    private String _getPKObjectFieldName(String pkObjectFieldName, boolean modifiable, boolean system, String shortName) {
        if (Validator.isNotNull((String)pkObjectFieldName)) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = TextFormatter.format((String)(shortName + "Id"), (int)8);
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            return pkObjectFieldName;
        }
        pkObjectFieldName = "c_" + pkObjectFieldName;
        return pkObjectFieldName;
    }

    private boolean _hasObjectField(List<ObjectField> newObjectFields, ObjectField oldObjectField) {
        for (ObjectField newObjectField : newObjectFields) {
            if (!Objects.equals(newObjectField.getName(), oldObjectField.getName())) continue;
            return true;
        }
        return false;
    }

    private void _invalidatePortalCache(ObjectDefinition objectDefinition) {
        PortalCache portalCache = this._multiVMPool.getPortalCache(FragmentEntryLink.class.getName());
        List layoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsages(objectDefinition.getCompanyId(), this._classNameLocalService.getClassNameId(objectDefinition.getClassName()), this._portal.getClassNameId(FragmentEntryLink.class));
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            Set availableLocales = this._language.getAvailableLocales(layoutClassedModelUsage.getGroupId());
            for (Locale locale : availableLocales) {
                portalCache.remove((Serializable)((Object)StringBundler.concat((Object[])new Object[]{layoutClassedModelUsage.getContainerKey(), "-", locale, "-", 0})));
            }
        }
    }

    private boolean _isUnmodifiableSystemObject(boolean modifiable, boolean system) {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-167253")) {
            return !modifiable && system;
        }
        return system;
    }

    private ObjectDefinition _publishObjectDefinition(long userId, ObjectDefinition objectDefinition) throws PortalException {
        int count = this._objectFieldPersistence.countByODI_S(objectDefinition.getObjectDefinitionId(), false);
        if (count == 0) {
            throw new RequiredObjectFieldException();
        }
        objectDefinition.setActive(true);
        objectDefinition.setStatus(0);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        this._createTable(objectDefinition.getDBTableName(), objectDefinition);
        this._createTable(objectDefinition.getExtensionDBTableName(), objectDefinition);
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId(), "manyToMany")) {
            this._objectRelationshipLocalService.createManyToManyObjectRelationshipTable(userId, objectRelationship);
        }
        this.deployObjectDefinition(objectDefinition);
        this._registerTransactionCallbackForCluster(_deployObjectDefinitionMethodKey, objectDefinition);
        return objectDefinition;
    }

    private void _registerTransactionCallbackForCluster(MethodKey methodKey, ObjectDefinition objectDefinition) {
        if (ClusterExecutorUtil.isEnabled()) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(methodKey, new Object[]{objectDefinition}), (boolean)true);
                clusterRequest.setFireAndForget(true);
                ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                return null;
            });
        }
    }

    private ObjectDefinition _updateObjectDefinition(String externalReferenceCode, ObjectDefinition objectDefinition, long accountEntryRestrictedObjectFieldId, long descriptionObjectFieldId, long titleObjectFieldId, boolean accountEntryRestricted, boolean active, String dbTableName, boolean enableCategorization, boolean enableComments, boolean enableLocalization, boolean enableObjectEntryHistory, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, boolean portlet, String pkObjectFieldDBColumnName, String pkObjectFieldName, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        boolean originalActive = objectDefinition.isActive();
        this._validateAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId, accountEntryRestricted, objectDefinition);
        this._validateObjectFieldId(objectDefinition, descriptionObjectFieldId);
        this._validateObjectFieldId(objectDefinition, titleObjectFieldId);
        this._validateActive(objectDefinition, active);
        this._validateEnableCategorization(enableCategorization, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateEnableComments(enableComments, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateEnableObjectEntryHistory(objectDefinition.isApproved(), objectDefinition.isEnableObjectEntryHistory() != enableObjectEntryHistory, objectDefinition.isModifiable(), objectDefinition.getStorageType(), objectDefinition.isSystem());
        this._validateLabel(labelMap);
        this._validatePluralLabel(pluralLabelMap);
        if (objectDefinition.getAccountEntryRestrictedObjectFieldId() != 0L) {
            this._objectFieldLocalService.updateRequired(objectDefinition.getAccountEntryRestrictedObjectFieldId(), false);
        }
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId > 0L) {
            this._objectFieldLocalService.updateRequired(accountEntryRestrictedObjectFieldId, true);
        }
        objectDefinition.setExternalReferenceCode(externalReferenceCode);
        objectDefinition.setAccountEntryRestrictedObjectFieldId(accountEntryRestrictedObjectFieldId);
        objectDefinition.setDescriptionObjectFieldId(descriptionObjectFieldId);
        objectDefinition.setTitleObjectFieldId(titleObjectFieldId);
        objectDefinition.setAccountEntryRestricted(accountEntryRestricted);
        objectDefinition.setActive(active);
        objectDefinition.setClassName(this._getClassName(objectDefinition.getObjectDefinitionId(), objectDefinition.getClassName(), objectDefinition.isModifiable(), objectDefinition.isSystem()));
        objectDefinition.setEnableCategorization(enableCategorization);
        objectDefinition.setEnableComments(enableComments);
        objectDefinition.setEnableObjectEntryHistory(enableObjectEntryHistory);
        objectDefinition.setLabelMap(labelMap, LocaleUtil.getSiteDefault());
        objectDefinition.setPanelAppOrder(panelAppOrder);
        objectDefinition.setPanelCategoryKey(panelCategoryKey);
        objectDefinition.setPortlet(portlet);
        objectDefinition.setPluralLabelMap(pluralLabelMap);
        if (objectDefinition.isApproved()) {
            if (!active && originalActive) {
                this.objectDefinitionLocalService.undeployObjectDefinition(objectDefinition);
            } else if (active) {
                this.objectDefinitionLocalService.deployObjectDefinition(objectDefinition);
            }
            if (active != originalActive) {
                this._updateWorkflowInstances(objectDefinition);
            }
            return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        }
        name = this._getName(name, objectDefinition.isModifiable(), objectDefinition.isSystem());
        String shortName = ObjectDefinitionImpl.getShortName(name);
        dbTableName = this._getDBTableName(dbTableName, objectDefinition.isModifiable(), name, objectDefinition.isSystem(), objectDefinition.getCompanyId(), shortName);
        pkObjectFieldName = this._getPKObjectFieldName(pkObjectFieldName, objectDefinition.isModifiable(), objectDefinition.isSystem(), shortName);
        pkObjectFieldDBColumnName = this._getPKObjectFieldDBColumnName(pkObjectFieldDBColumnName, pkObjectFieldName, objectDefinition.isModifiable(), objectDefinition.isSystem());
        this._validateName(objectDefinition.getObjectDefinitionId(), objectDefinition.getCompanyId(), objectDefinition.isModifiable(), name, objectDefinition.isSystem());
        this._validateScope(scope);
        objectDefinition.setDBTableName(dbTableName);
        objectDefinition.setEnableLocalization(enableLocalization);
        objectDefinition.setName(name);
        objectDefinition.setPKObjectFieldDBColumnName(pkObjectFieldDBColumnName);
        objectDefinition.setPKObjectFieldName(pkObjectFieldName);
        objectDefinition.setScope(scope);
        objectDefinition = (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), "")) {
            objectField.setDBTableName(objectDefinition.getDBTableName());
            this._objectFieldLocalService.updateObjectField(objectField);
        }
        return objectDefinition;
    }

    private ObjectDefinition _updateTitleObjectFieldId(ObjectDefinition objectDefinition, String titleObjectFieldName) throws PortalException {
        if (Validator.isNull((String)titleObjectFieldName)) {
            titleObjectFieldName = "id";
        }
        ObjectField objectField = this._objectFieldPersistence.findByODI_N(objectDefinition.getObjectDefinitionId(), titleObjectFieldName);
        this._validateObjectFieldId(objectDefinition, objectField.getObjectFieldId());
        objectDefinition.setTitleObjectFieldId(objectField.getObjectFieldId());
        return (ObjectDefinition)this.objectDefinitionPersistence.update((BaseModel)objectDefinition);
    }

    private void _updateWorkflowInstances(ObjectDefinition objectDefinition) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._objectEntryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property objectDefinitionIdProperty = PropertyFactoryUtil.forName((String)"objectDefinitionId");
            dynamicQuery.add(objectDefinitionIdProperty.eq((Object)objectDefinition.getObjectDefinitionId()));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.ne((Object)0));
        });
        actionableDynamicQuery.setParallel(true);
        actionableDynamicQuery.setPerformActionMethod(objectEntry -> {
            WorkflowInstanceLink workflowInstanceLink = this._workflowInstanceLinkLocalService.fetchWorkflowInstanceLink(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
            if (workflowInstanceLink != null) {
                this._workflowInstanceManager.updateActive(objectDefinition.getUserId(), objectDefinition.getCompanyId(), workflowInstanceLink.getWorkflowInstanceId(), objectDefinition.isActive());
            }
        });
        actionableDynamicQuery.performActions();
    }

    private void _validateAccountEntryRestrictedObjectFieldId(long accountEntryRestrictedObjectFieldId, boolean accountEntryRestricted, ObjectDefinition objectDefinition) throws ObjectDefinitionAccountEntryRestrictedException, ObjectDefinitionAccountEntryRestrictedObjectFieldIdException {
        if (accountEntryRestricted && accountEntryRestrictedObjectFieldId == 0L) {
            throw new ObjectDefinitionAccountEntryRestrictedObjectFieldIdException();
        }
        if (objectDefinition.isApproved() && objectDefinition.isAccountEntryRestricted() && !accountEntryRestricted) {
            throw new ObjectDefinitionAccountEntryRestrictedException("Account entry restriction cannot be disabled when the object definition is published");
        }
    }

    private void _validateActive(ObjectDefinition objectDefinition, boolean active) throws PortalException {
        if (active && !objectDefinition.isApproved()) {
            throw new ObjectDefinitionActiveException("Object definitions must be published before being activated");
        }
    }

    private void _validateEnableCategorization(boolean enableCategorization, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (enableCategorization && this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableCategorizationException("Enable categorization is not allowed for system object definitions");
        }
        if (enableCategorization && !StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableCategorizationException("Enable categorization is only allowed for object definitions with the default storage type");
        }
    }

    private void _validateEnableComments(boolean enableComments, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (enableComments && this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableCommentsException("Enable comments is not allowed for system object definitions");
        }
        if (enableComments && !StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableCategorizationException("Enable comments is only allowed for object definitions with the default storage type");
        }
    }

    private void _validateEnableObjectEntryHistory(boolean approved, boolean enableObjectEntryHistoryChanged, boolean modifiable, String storageType, boolean system) throws PortalException {
        if (!enableObjectEntryHistoryChanged) {
            return;
        }
        if (this._isUnmodifiableSystemObject(modifiable, system)) {
            throw new ObjectDefinitionEnableObjectEntryHistoryException("Enable object entry history is not allowed for system object definitions");
        }
        if (!StringUtil.equals((String)storageType, (String)"default")) {
            throw new ObjectDefinitionEnableObjectEntryHistoryException("Enable object entry history is only allowed for object definitions with the default storage type");
        }
        if (approved) {
            throw new ObjectDefinitionEnableObjectEntryHistoryException("Enable object entry history cannot be updated when the object definition is published");
        }
    }

    private void _validateLabel(Map<Locale, String> labelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (labelMap == null || Validator.isNull((String)labelMap.get(locale))) {
            throw new ObjectDefinitionLabelException("Label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateName(long objectDefinitionId, long companyId, boolean modifiable, String name, boolean system) throws PortalException {
        if (Validator.isNull((String)name) || !system && name.equals("C_")) {
            throw new ObjectDefinitionNameException.MustNotBeNull();
        }
        if (this._isUnmodifiableSystemObject(modifiable, system) && (name.startsWith("C_") || name.startsWith("c_"))) {
            throw new ObjectDefinitionNameException.MustNotStartWithCAndUnderscoreForSystemObject();
        }
        if (!system && !name.startsWith("C_")) {
            throw new ObjectDefinitionNameException.MustStartWithCAndUnderscoreForCustomObject();
        }
        char[] nameCharArray = name.toCharArray();
        for (int i = 0; i < nameCharArray.length; ++i) {
            char c;
            if ((modifiable || !system) && (i == 0 || i == 1) || Validator.isChar((char)(c = nameCharArray[i])) || Validator.isDigit((char)c)) continue;
            throw new ObjectDefinitionNameException.MustOnlyContainLettersAndDigits();
        }
        if (system && !Character.isUpperCase(nameCharArray[0]) || !system && !Character.isUpperCase(nameCharArray[2])) {
            throw new ObjectDefinitionNameException.MustBeginWithUpperCaseLetter();
        }
        if (system && nameCharArray.length > 41 || !system && nameCharArray.length > 43) {
            throw new ObjectDefinitionNameException.MustBeLessThan41Characters();
        }
        ObjectDefinition objectDefinition = this.objectDefinitionPersistence.fetchByC_N(companyId, name);
        if (objectDefinition != null && objectDefinition.getObjectDefinitionId() != objectDefinitionId) {
            throw new ObjectDefinitionNameException.MustNotBeDuplicate(name);
        }
    }

    private void _validateObjectFieldId(ObjectDefinition objectDefinition, long objectFieldId) throws PortalException {
        if (objectFieldId <= 0L) {
            return;
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectFieldId);
        if (objectField == null || objectField.getObjectDefinitionId() != objectDefinition.getObjectDefinitionId()) {
            throw new NoSuchObjectFieldException();
        }
        if (Validator.isNotNull((String)objectField.getRelationshipType())) {
            throw new ObjectFieldRelationshipTypeException("Description and title object fields cannot have a relationship type");
        }
    }

    private void _validatePluralLabel(Map<Locale, String> pluralLabelMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (pluralLabelMap == null || Validator.isNull((String)pluralLabelMap.get(locale))) {
            throw new ObjectDefinitionPluralLabelException("Plural label is null for locale " + locale.getDisplayName());
        }
    }

    private void _validateScope(String scope) throws PortalException {
        if (Validator.isNull((String)scope)) {
            throw new ObjectDefinitionScopeException("Scope is null");
        }
        try {
            this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ObjectDefinitionScopeException(illegalArgumentException.getMessage());
        }
    }

    private void _validateVersion(boolean system, int version) throws PortalException {
        if (system) {
            if (version <= 0) {
                throw new ObjectDefinitionVersionException("System object definition versions must greater than 0");
            }
        } else if (version != 0) {
            throw new ObjectDefinitionVersionException("Custom object definition versions must be 0");
        }
    }
}

