/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.system.model.listener;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.extension.EntityExtensionThreadLocal;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class SystemObjectDefinitionMetadataModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    private static final Log _log = LogFactoryUtil.getLog(SystemObjectDefinitionMetadataModelListener.class);
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final JSONFactory _jsonFactory;
    private final Class<?> _modelClass;
    private final ObjectActionEngine _objectActionEngine;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    private final SystemObjectDefinitionMetadata _systemObjectDefinitionMetadata;
    private final UserLocalService _userLocalService;

    public SystemObjectDefinitionMetadataModelListener(DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, Class<T> modelClass, ObjectActionEngine objectActionEngine, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectValidationRuleLocalService objectValidationRuleLocalService, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata, UserLocalService userLocalService) {
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._jsonFactory = jsonFactory;
        this._modelClass = modelClass;
        this._objectActionEngine = objectActionEngine;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectValidationRuleLocalService = objectValidationRuleLocalService;
        this._systemObjectDefinitionMetadata = systemObjectDefinitionMetadata;
        this._userLocalService = userLocalService;
    }

    public Class<?> getModelClass() {
        return this._modelClass;
    }

    public void onAfterCreate(T baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterAdd", null, (BaseModel)baseModel.clone());
    }

    public void onAfterRemove(T baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterDelete", baseModel, baseModel);
    }

    public void onAfterUpdate(T originalBaseModel, T baseModel) throws ModelListenerException {
        this._executeObjectActions("onAfterUpdate", originalBaseModel, (BaseModel)baseModel.clone());
    }

    public void onBeforeCreate(T model) throws ModelListenerException {
        this._validateSystemObject(null, model);
    }

    public void onBeforeRemove(T baseModel) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(baseModel), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            EntityExtensionThreadLocal.setExtendedProperties((Map)HashMapBuilder.putAll((Map)this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()))).putAll(EntityExtensionThreadLocal.getExtendedProperties()).build());
            this._objectEntryLocalService.deleteExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()));
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeUpdate(T originalModel, T model) throws ModelListenerException {
        this._validateSystemObject(originalModel, model);
    }

    private void _executeObjectActions(String objectActionTriggerKey, T originalBaseModel, T baseModel) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(baseModel), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = this._getUserId(baseModel);
            }
            this._objectActionEngine.executeObjectActions(this._modelClass.getName(), this._getCompanyId(baseModel), objectActionTriggerKey, this._getPayloadJSONObject(objectActionTriggerKey, objectDefinition, originalBaseModel, baseModel, userId), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private long _getCompanyId(T baseModel) {
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("companyId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a company ID column");
        }
        return (Long)function.apply(baseModel);
    }

    private DTOConverter<T, ?> _getDTOConverter() {
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = this._systemObjectDefinitionMetadata.getJaxRsApplicationDescriptor();
        return this._dtoConverterRegistry.getDTOConverter(jaxRsApplicationDescriptor.getApplicationName(), this._modelClass.getName(), jaxRsApplicationDescriptor.getVersion());
    }

    private String _getDTOConverterType() {
        DTOConverter<T, ?> dtoConverter = this._getDTOConverter();
        if (dtoConverter == null) {
            return this._modelClass.getSimpleName();
        }
        return dtoConverter.getContentType();
    }

    private JSONObject _getPayloadJSONObject(String objectActionTriggerKey, ObjectDefinition objectDefinition, T originalBaseModel, T baseModel, long userId) throws PortalException {
        String dtoConverterType = this._getDTOConverterType();
        return JSONUtil.put((String)"classPK", (Object)baseModel.getPrimaryKeyObj()).put("extendedProperties", (Object)HashMapBuilder.putAll((Map)this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()))).putAll(EntityExtensionThreadLocal.getExtendedProperties()).build()).put("model" + this._modelClass.getSimpleName(), (Object)baseModel.getModelAttributes()).put("modelDTO" + dtoConverterType, this._toDTO(baseModel, userId)).put("objectActionTriggerKey", objectActionTriggerKey).put("original" + this._modelClass.getSimpleName(), () -> {
            if (originalBaseModel == null) {
                return null;
            }
            return originalBaseModel.getModelAttributes();
        }).put("originalDTO" + dtoConverterType, () -> {
            if (originalBaseModel == null) {
                return null;
            }
            return this._toDTO(originalBaseModel, userId);
        });
    }

    private long _getUserId(T baseModel) {
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("userId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a user ID column");
        }
        return (Long)function.apply(baseModel);
    }

    private Map<String, Object> _toDTO(T baseModel, long userId) {
        DTOConverter<T, ?> dtoConverter = this._getDTOConverter();
        Map modelAttributes = baseModel.getModelAttributes();
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + this._modelClass.getName()));
            }
            return modelAttributes;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user found with user ID " + userId));
            }
            return modelAttributes;
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, (Object)baseModel.getPrimaryKeyObj(), user.getLocale(), null, user);
        try {
            Object object = dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext);
            if (object == null) {
                return modelAttributes;
            }
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(object));
            return jsonObject.put("createDate", modelAttributes.get("createDate")).put("modifiedDate", modelAttributes.get("modifiedDate")).put("status", modelAttributes.get("status")).put("userName", user.getFullName()).put("uuid", modelAttributes.get("uuid")).toMap();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return baseModel.getModelAttributes();
        }
    }

    private void _validateSystemObject(T originalModel, T model) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(model), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = this._getUserId(model);
            }
            this._objectValidationRuleLocalService.validate(model, objectDefinition.getObjectDefinitionId(), this._getPayloadJSONObject(null, objectDefinition, originalModel, model, userId), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

