/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;

public class ObjectEntryPortletResourcePermissionLogic
implements PortletResourcePermissionLogic {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryPortletResourcePermissionLogic.class);
    private final AccountEntryLocalService _accountEntryLocalService;
    private final GroupLocalService _groupLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final OrganizationLocalService _organizationLocalService;

    public ObjectEntryPortletResourcePermissionLogic(AccountEntryLocalService accountEntryLocalService, GroupLocalService groupLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, OrganizationLocalService organizationLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._groupLocalService = groupLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._organizationLocalService = organizationLocalService;
    }

    public Boolean contains(PermissionChecker permissionChecker, String name, Group group, String actionId) {
        try {
            return this._contains(permissionChecker, name, group, actionId);
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
    }

    private Boolean _contains(PermissionChecker permissionChecker, String name, Group group, String actionId) throws PortalException {
        if (permissionChecker.hasPermission(group, name, 0L, actionId)) {
            return true;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)StringUtil.removeSubstring((String)name, (String)"com.liferay.object#")));
        if (!objectDefinition.isAccountEntryRestricted()) {
            return false;
        }
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1);
        for (AccountEntry accountEntry : accountEntries) {
            if (!permissionChecker.hasPermission(accountEntry.getAccountEntryGroupId(), name, 0L, actionId)) continue;
            return true;
        }
        List organizations = this._organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        for (Organization organization : organizations) {
            Group organizationGroup = this._groupLocalService.getOrganizationGroup(permissionChecker.getCompanyId(), organization.getOrganizationId());
            if (!permissionChecker.hasPermission(organizationGroup.getGroupId(), name, 0L, actionId)) continue;
            return true;
        }
        return false;
    }
}

