/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectEntry1to1ObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final long _companyId;
    private final ObjectEntryService _objectEntryService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntry1to1ObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryService objectEntryService, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryService = objectEntryService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
        this._companyId = objectDefinition.getCompanyId();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, 0, 1);
        if (relatedModels.isEmpty()) {
            return;
        }
        ObjectEntry objectEntry = relatedModels.get(0);
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade")) {
            this._objectEntryService.deleteObjectEntry(objectEntry.getObjectEntryId());
        } else if (Objects.equals(objectRelationship.getDeletionType(), "disassociate")) {
            this._objectEntryService.updateObjectEntry(objectEntry.getObjectEntryId(), (Map)HashMapBuilder.put(() -> {
                ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
                return objectField.getName();
            }, (Object)0).build(), new ServiceContext());
        } else if (Objects.equals(objectRelationship.getDeletionType(), "prevent")) {
            throw new RequiredObjectRelationshipException(StringBundler.concat((Object[])new Object[]{"Object relationship ", objectRelationship.getObjectRelationshipId(), " does not allow deletes"}));
        }
    }

    public void disassociateRelatedModels(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        this._objectEntryService.updateObjectEntry(primaryKey1, (Map)HashMapBuilder.put(() -> {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
            ObjectField objectField = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
            return objectField.getName();
        }, (Object)0).build(), new ServiceContext());
    }

    public String getClassName() {
        return this._className;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getObjectRelationshipType() {
        return "oneToOne";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        return this._objectEntryService.getOneToManyObjectEntries(groupId, objectRelationshipId, primaryKey, true, 0, 1);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        List<ObjectEntry> relatedModels = this.getRelatedModels(groupId, objectRelationshipId, primaryKey, 0, 1);
        return relatedModels.size();
    }
}

