/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.notification.term.contributor;

import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.object.definition.notification.term.util.ObjectDefinitionNotificationTermUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.function.UnsafeTriFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ObjectDefinitionNotificationTermEvaluator
implements NotificationTermEvaluator {
    private final List<EvaluatorFunction> _evaluatorFunctions = Arrays.asList(this::_evaluateAuthor, this::_evaluateCurrentUser, this::_evaluateObjectFields);
    private final ListTypeLocalService _listTypeLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final UserLocalService _userLocalService;

    public ObjectDefinitionNotificationTermEvaluator(ListTypeLocalService listTypeLocalService, ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, UserLocalService userLocalService) {
        this._listTypeLocalService = listTypeLocalService;
        this._objectDefinition = objectDefinition;
        this._objectFieldLocalService = objectFieldLocalService;
        this._userLocalService = userLocalService;
    }

    public String evaluate(NotificationTermEvaluator.Context context, Object object, String termName) throws PortalException {
        if (!(object instanceof Map)) {
            return termName;
        }
        Map termValues = (Map)object;
        for (EvaluatorFunction evaluatorFunction : this._evaluatorFunctions) {
            String termValue = (String)evaluatorFunction.apply(context, termName, termValues);
            if (termValue == null) continue;
            return termValue;
        }
        return termName;
    }

    private String _evaluateAuthor(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        String prefix = StringUtil.toUpperCase((String)this._objectDefinition.getShortName());
        if (!(termName.equals("[%" + prefix + "_AUTHOR_EMAIL_ADDRESS%]") || termName.equals("[%" + prefix + "_AUTHOR_FIRST_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_ID%]") || termName.equals("[%" + prefix + "_AUTHOR_LAST_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_MIDDLE_NAME%]") || termName.equals("[%" + prefix + "_AUTHOR_PREFIX%]") || termName.equals("[%" + prefix + "_AUTHOR_SUFFIX%]") || termName.equals("[%" + prefix + "_CREATOR%]"))) {
            return null;
        }
        User user = this._userLocalService.getUser(GetterUtil.getLong((Object)termValues.get("creator")));
        if (termName.equals("[%" + prefix + "_CREATOR%]")) {
            if (context.equals((Object)NotificationTermEvaluator.Context.RECIPIENT)) {
                return String.valueOf(termValues.get("creator"));
            }
            return user.getFullName(true, true);
        }
        return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)("[%" + prefix + "_AUTHOR_")), user);
    }

    private String _evaluateCurrentUser(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        if (!(termName.equals("[%CURRENT_USER_EMAIL_ADDRESS%]") || termName.equals("[%CURRENT_USER_FIRST_NAME%]") || termName.equals("[%CURRENT_USER_ID%]") || termName.equals("[%CURRENT_USER_LAST_NAME%]") || termName.equals("[%CURRENT_USER_MIDDLE_NAME%]") || termName.equals("[%CURRENT_USER_PREFIX%]") || termName.equals("[%CURRENT_USER_SUFFIX%]"))) {
            return null;
        }
        return this._getTermValue(StringUtil.removeSubstring((String)termName, (String)"[%CURRENT_USER_"), this._userLocalService.getUser(GetterUtil.getLong((Object)termValues.get("currentUserId"))));
    }

    private String _evaluateObjectFields(NotificationTermEvaluator.Context context, String termName, Map<String, Object> termValues) throws PortalException {
        if (termName.equals("[%OBJECT_ENTRY_CREATOR%]")) {
            return termName;
        }
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId())) {
            if (!Objects.equals(ObjectDefinitionNotificationTermUtil.getObjectFieldTermName((String)this._objectDefinition.getShortName(), (String)objectField.getName()), termName)) continue;
            String termValue = String.valueOf(termValues.get(objectField.getName()));
            if (Validator.isNotNull((String)termValue)) {
                return termValue;
            }
            return String.valueOf(termValues.get(objectField.getDBColumnName()));
        }
        return null;
    }

    private String _getTermValue(String partialTermName, User user) throws PortalException {
        if (partialTermName.equals("EMAIL_ADDRESS%]")) {
            return user.getEmailAddress();
        }
        if (partialTermName.equals("FIRST_NAME%]")) {
            return user.getFirstName();
        }
        if (partialTermName.equals("ID%]")) {
            return String.valueOf(user.getUserId());
        }
        if (partialTermName.equals("LAST_NAME%]")) {
            return user.getLastName();
        }
        if (partialTermName.equals("MIDDLE_NAME%]")) {
            return user.getMiddleName();
        }
        if (partialTermName.equals("PREFIX%]") || partialTermName.equals("SUFFIX%]")) {
            Contact contact = user.fetchContact();
            if (contact == null) {
                return "";
            }
            long listTypeId = contact.getPrefixListTypeId();
            if (partialTermName.equals("SUFFIX%]")) {
                listTypeId = contact.getSuffixListTypeId();
            }
            if (listTypeId == 0L) {
                return "";
            }
            ListType listType = this._listTypeLocalService.getListType(listTypeId);
            return listType.getName();
        }
        return null;
    }

    @FunctionalInterface
    public static interface EvaluatorFunction
    extends UnsafeTriFunction<NotificationTermEvaluator.Context, String, Map<String, Object>, String, PortalException> {
    }
}

