/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.object.constants.ObjectSAPConstants;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class SAPEntryPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SAPEntryPortalInstanceLifecycleListener.class);
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) {
        try {
            this._addSAPEntry(company.getCompanyId());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
        }
    }

    private void _addSAPEntry(long companyId) throws PortalException {
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, "OBJECT_DEFAULT");
        if (sapEntry != null) {
            return;
        }
        this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), ObjectSAPConstants.ALLOWED_SERVICE_SIGNATURES, true, true, "OBJECT_DEFAULT", ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER, (String)"service-access-policy-entry-default-object-title"), new ServiceContext());
    }
}

