/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingNameException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Text"}, service={ObjectFieldBusinessType.class})
public class TextObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"maxLength", "showCounter"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-text-up-to-280-characters");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "text");
    }

    public String getName() {
        return "Text";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectField, objectFieldSettings);
        HashMap objectFieldSettingsValues = new HashMap();
        objectFieldSettings.forEach(objectFieldSetting -> objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        String showCounter = (String)objectFieldSettingsValues.get("showCounter");
        if (Validator.isNull((String)showCounter) || StringUtil.equalsIgnoreCase((String)showCounter, (String)"false")) {
            if (objectFieldSettingsValues.containsKey("maxLength")) {
                throw new ObjectFieldSettingNameException.NotAllowedNames(objectField.getName(), Collections.singleton("maxLength"));
            }
        } else if (StringUtil.equalsIgnoreCase((String)showCounter, (String)"true")) {
            String maxLength = (String)objectFieldSettingsValues.get("maxLength");
            if (Validator.isNull((String)maxLength)) {
                throw new ObjectFieldSettingValueException.MissingRequiredValues(objectField.getName(), Collections.singleton("maxLength"));
            }
            int maxLengthInteger = GetterUtil.getInteger((String)maxLength);
            if (maxLengthInteger < 1 || maxLengthInteger > 280) {
                throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "maxLength", maxLength);
            }
        } else {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "showCounter", showCounter);
        }
    }
}

