/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.exception.ObjectFieldDefaultValueException;
import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.exception.ObjectFieldStateException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectState;
import com.liferay.object.model.ObjectStateFlow;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.object.service.ObjectStateFlowLocalService;
import com.liferay.object.service.ObjectStateLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Picklist"}, service={ObjectFieldBusinessType.class})
public class PicklistObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private ObjectStateFlowLocalService _objectStateFlowLocalService;
    @Reference
    private ObjectStateLocalService _objectStateLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-163716")) {
            return SetUtil.fromArray((Object[])new String[]{"stateFlow"});
        }
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType", "stateFlow"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "select";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "choose-from-a-picklist");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "picklist");
    }

    public String getName() {
        return "Picklist";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"options", (Object)this._getDDMFormFieldOptions(objectField, objectFieldRenderingContext)).put((Object)"predefinedValue", () -> {
            LocalizedValue localizedValue = new LocalizedValue(objectFieldRenderingContext.getLocale());
            localizedValue.addString(objectFieldRenderingContext.getLocale(), ObjectFieldSettingUtil.getDefaultValueAsString(null, (long)objectField.getObjectFieldId(), (ObjectFieldSettingLocalService)this._objectFieldSettingLocalService, null));
            return localizedValue;
        }).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        if (!objectField.isState()) {
            return Collections.emptySet();
        }
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType"});
    }

    public void predefineObjectFieldSettings(ObjectField newObjectField, ObjectField oldObjectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        if (oldObjectField != null) {
            this._objectStateFlowLocalService.updateDefaultObjectStateFlow(newObjectField, oldObjectField);
            return;
        }
        for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
            if (!StringUtil.equals((String)objectFieldSetting.getName(), (String)"stateFlow") || objectFieldSetting.getObjectStateFlow() == null) continue;
            ObjectStateFlow objectStateFlow = objectFieldSetting.getObjectStateFlow();
            this._objectStateFlowLocalService.addObjectStateFlow(newObjectField.getUserId(), newObjectField.getObjectFieldId(), objectStateFlow.getObjectStates());
            return;
        }
        this._objectStateFlowLocalService.addDefaultObjectStateFlow(newObjectField);
    }

    public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        if (objectFieldSettingsValuesMap.isEmpty()) {
            return;
        }
        super.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
        String defaultValue = objectFieldSettingsValuesMap.get("defaultValue");
        String defaultValueType = objectFieldSettingsValuesMap.get("defaultValueType");
        if (defaultValue == null || StringUtil.equals((String)defaultValueType, (String)"expressionBuilder")) {
            return;
        }
        ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), defaultValue);
        if (listTypeEntry == null) {
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-163716")) {
                throw new ObjectFieldDefaultValueException(StringBundler.concat((String[])new String[]{"Default value \"", defaultValue, "\" is not a list entry in list definition ", String.valueOf(objectField.getListTypeDefinitionId())}));
            }
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "defaultValue", defaultValue);
        }
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-163716") && !objectField.isState()) {
            throw new ObjectFieldStateException("Object field default value can only be set when the picklist is a state");
        }
    }

    private DDMFormFieldOptions _getDDMFormFieldOptions(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (ListTypeEntry listTypeEntry : this._getListTypeEntries(objectField, objectFieldRenderingContext)) {
            ddmFormFieldOptions.addOptionLabel(listTypeEntry.getKey(), objectFieldRenderingContext.getLocale(), GetterUtil.getString((String)listTypeEntry.getName(objectFieldRenderingContext.getLocale()), (String)listTypeEntry.getName(listTypeEntry.getDefaultLanguageId())));
        }
        return ddmFormFieldOptions;
    }

    private List<ListTypeEntry> _getListTypeEntries(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        ListTypeEntry listTypeEntry;
        if (!objectField.isState()) {
            return this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
        }
        String listEntryKey = ObjectFieldSettingUtil.getDefaultValueAsString(null, (long)objectField.getObjectFieldId(), (ObjectFieldSettingLocalService)this._objectFieldSettingLocalService, null);
        if (MapUtil.isNotEmpty((Map)objectFieldRenderingContext.getProperties())) {
            ListEntry listEntry = (ListEntry)objectFieldRenderingContext.getProperty(objectField.getName());
            if (listEntry == null) {
                return this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
            }
            listEntryKey = listEntry.getKey();
        }
        if ((listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(objectField.getListTypeDefinitionId(), listEntryKey)) == null) {
            return Collections.emptyList();
        }
        ObjectStateFlow objectStateFlow = this._objectStateFlowLocalService.fetchObjectFieldObjectStateFlow(objectField.getObjectFieldId());
        ObjectState objectState = this._objectStateLocalService.getObjectStateFlowObjectState(listTypeEntry.getListTypeEntryId(), objectStateFlow.getObjectStateFlowId());
        List listTypeEntries = TransformUtil.transform((Collection)this._objectStateLocalService.getNextObjectStates(objectState.getObjectStateId()), nextObjectState -> this._listTypeEntryLocalService.getListTypeEntry(nextObjectState.getListTypeEntryId()));
        listTypeEntries.add(this._listTypeEntryLocalService.getListTypeEntry(objectState.getListTypeEntryId()));
        return listTypeEntries;
    }
}

