/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class AddObjectEntryObjectActionExecutorImpl
implements ObjectActionExecutor {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(long companyId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        ObjectDefinition sourceObjectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(payloadJSONObject.getLong("objectDefinitionId"));
        ObjectDefinition targetObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)((String)parametersUnicodeProperties.get((Object)"objectDefinitionId"))));
        long primaryKey = this._execute(this._getGroupId(companyId, payloadJSONObject, sourceObjectDefinition, targetObjectDefinition), targetObjectDefinition, this._userLocalService.getUser(userId), ObjectEntryVariablesUtil.getValues(this._ddmExpressionFactory, parametersUnicodeProperties, ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, sourceObjectDefinition, payloadJSONObject, this._systemObjectDefinitionMetadataRegistry)));
        if (!GetterUtil.getBoolean((String)((String)parametersUnicodeProperties.get((Object)"relatedObjectEntries")))) {
            return;
        }
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(sourceObjectDefinition.getObjectDefinitionId())) {
            if (!Objects.equals(objectRelationship.getObjectDefinitionId2(), targetObjectDefinition.getObjectDefinitionId())) continue;
            this._objectRelationshipLocalService.addObjectRelationshipMappingTableValues(userId, objectRelationship.getObjectRelationshipId(), payloadJSONObject.getLong("classPK"), primaryKey, this._getServiceContext(companyId, userId));
        }
    }

    public String getKey() {
        return "add-object-entry";
    }

    private long _execute(long groupId, ObjectDefinition objectDefinition, User user, final Map<String, Object> values) throws Exception {
        if (objectDefinition.isSystem()) {
            if (!FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPS-173537")) {
                throw new UnsupportedOperationException();
            }
            SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName());
            return systemObjectDefinitionMetadata.addBaseModel(user, values);
        }
        ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType());
        ObjectEntry objectEntry = objectEntryManager.addObjectEntry((DTOConverterContext)new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, null, user.getLocale(), null, user), objectDefinition, new ObjectEntry(){
            {
                this.properties = values;
            }
        }, String.valueOf(groupId));
        return objectEntry.getId();
    }

    private long _getGroupId(long companyId, JSONObject payloadJSONObject, ObjectDefinition sourceObjectDefinition, ObjectDefinition targetObjectDefinition) throws Exception {
        ObjectScopeProvider targetObjectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(targetObjectDefinition.getScope());
        if (!targetObjectScopeProvider.isGroupAware()) {
            return 0L;
        }
        ObjectScopeProvider sourceObjectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(sourceObjectDefinition.getScope());
        if (!sourceObjectScopeProvider.isGroupAware()) {
            Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
            return companyGroup.getGroupId();
        }
        if (sourceObjectDefinition.isSystem()) {
            return MapUtil.getLong((Map)((Map)payloadJSONObject.get("model" + sourceObjectDefinition.getName())), (String)"groupId");
        }
        return MapUtil.getLong((Map)((Map)payloadJSONObject.get("objectEntry")), (String)"groupId");
    }

    private ServiceContext _getServiceContext(final long companyId, final long userId) {
        return new ServiceContext(){
            {
                this.setCompanyId(companyId);
                this.setUserId(userId);
            }
        };
    }
}

