/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectViewSortColumn;
import com.liferay.object.model.ObjectViewSortColumnModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectViewSortColumn service. Represents a row in the &quot;ObjectViewSortColumn&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectViewSortColumnModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectViewSortColumnImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectViewSortColumnImpl
 * @generated
 */
public class ObjectViewSortColumnModelImpl
	extends BaseModelImpl<ObjectViewSortColumn>
	implements ObjectViewSortColumnModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object view sort column model instance should use the <code>ObjectViewSortColumn</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectViewSortColumn";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectViewSortColumnId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectViewId", Types.BIGINT}, {"objectFieldName", Types.VARCHAR},
		{"priority", Types.INTEGER}, {"sortOrder", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectViewSortColumnId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectViewId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectFieldName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("sortOrder", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectViewSortColumn (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectViewSortColumnId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectViewId LONG,objectFieldName VARCHAR(75) null,priority INTEGER,sortOrder VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table ObjectViewSortColumn";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectViewSortColumn.objectViewSortColumnId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectViewSortColumn.objectViewSortColumnId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDNAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWSORTCOLUMNID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectViewSortColumnModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectViewSortColumnId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectViewSortColumnId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectViewSortColumnId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectViewSortColumn.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectViewSortColumn.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectViewSortColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectViewSortColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewSortColumn, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectViewSortColumn)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectViewSortColumn, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectViewSortColumn, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectViewSortColumn)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectViewSortColumn, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectViewSortColumn, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectViewSortColumn, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectViewSortColumn, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectViewSortColumn, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectViewSortColumn::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectViewSortColumn::getUuid);
			attributeGetterFunctions.put(
				"objectViewSortColumnId",
				ObjectViewSortColumn::getObjectViewSortColumnId);
			attributeGetterFunctions.put(
				"companyId", ObjectViewSortColumn::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectViewSortColumn::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectViewSortColumn::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectViewSortColumn::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectViewSortColumn::getModifiedDate);
			attributeGetterFunctions.put(
				"objectViewId", ObjectViewSortColumn::getObjectViewId);
			attributeGetterFunctions.put(
				"objectFieldName", ObjectViewSortColumn::getObjectFieldName);
			attributeGetterFunctions.put(
				"priority", ObjectViewSortColumn::getPriority);
			attributeGetterFunctions.put(
				"sortOrder", ObjectViewSortColumn::getSortOrder);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<ObjectViewSortColumn, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectViewSortColumn, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectViewSortColumn, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectViewSortColumn, Long>)
					ObjectViewSortColumn::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectViewSortColumn, String>)
					ObjectViewSortColumn::setUuid);
			attributeSetterBiConsumers.put(
				"objectViewSortColumnId",
				(BiConsumer<ObjectViewSortColumn, Long>)
					ObjectViewSortColumn::setObjectViewSortColumnId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectViewSortColumn, Long>)
					ObjectViewSortColumn::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectViewSortColumn, Long>)
					ObjectViewSortColumn::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectViewSortColumn, String>)
					ObjectViewSortColumn::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectViewSortColumn, Date>)
					ObjectViewSortColumn::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectViewSortColumn, Date>)
					ObjectViewSortColumn::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectViewId",
				(BiConsumer<ObjectViewSortColumn, Long>)
					ObjectViewSortColumn::setObjectViewId);
			attributeSetterBiConsumers.put(
				"objectFieldName",
				(BiConsumer<ObjectViewSortColumn, String>)
					ObjectViewSortColumn::setObjectFieldName);
			attributeSetterBiConsumers.put(
				"priority",
				(BiConsumer<ObjectViewSortColumn, Integer>)
					ObjectViewSortColumn::setPriority);
			attributeSetterBiConsumers.put(
				"sortOrder",
				(BiConsumer<ObjectViewSortColumn, String>)
					ObjectViewSortColumn::setSortOrder);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectViewSortColumnId() {
		return _objectViewSortColumnId;
	}

	@Override
	public void setObjectViewSortColumnId(long objectViewSortColumnId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewSortColumnId = objectViewSortColumnId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectViewId() {
		return _objectViewId;
	}

	@Override
	public void setObjectViewId(long objectViewId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewId = objectViewId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectViewId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectViewId"));
	}

	@Override
	public String getObjectFieldName() {
		if (_objectFieldName == null) {
			return "";
		}
		else {
			return _objectFieldName;
		}
	}

	@Override
	public void setObjectFieldName(String objectFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldName = objectFieldName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalObjectFieldName() {
		return getColumnOriginalValue("objectFieldName");
	}

	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@Override
	public String getSortOrder() {
		if (_sortOrder == null) {
			return "";
		}
		else {
			return _sortOrder;
		}
	}

	@Override
	public void setSortOrder(String sortOrder) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sortOrder = sortOrder;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectViewSortColumn.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectViewSortColumn.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectViewSortColumn toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectViewSortColumn>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectViewSortColumnImpl objectViewSortColumnImpl =
			new ObjectViewSortColumnImpl();

		objectViewSortColumnImpl.setMvccVersion(getMvccVersion());
		objectViewSortColumnImpl.setUuid(getUuid());
		objectViewSortColumnImpl.setObjectViewSortColumnId(
			getObjectViewSortColumnId());
		objectViewSortColumnImpl.setCompanyId(getCompanyId());
		objectViewSortColumnImpl.setUserId(getUserId());
		objectViewSortColumnImpl.setUserName(getUserName());
		objectViewSortColumnImpl.setCreateDate(getCreateDate());
		objectViewSortColumnImpl.setModifiedDate(getModifiedDate());
		objectViewSortColumnImpl.setObjectViewId(getObjectViewId());
		objectViewSortColumnImpl.setObjectFieldName(getObjectFieldName());
		objectViewSortColumnImpl.setPriority(getPriority());
		objectViewSortColumnImpl.setSortOrder(getSortOrder());

		objectViewSortColumnImpl.resetOriginalValues();

		return objectViewSortColumnImpl;
	}

	@Override
	public ObjectViewSortColumn cloneWithOriginalValues() {
		ObjectViewSortColumnImpl objectViewSortColumnImpl =
			new ObjectViewSortColumnImpl();

		objectViewSortColumnImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectViewSortColumnImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectViewSortColumnImpl.setObjectViewSortColumnId(
			this.<Long>getColumnOriginalValue("objectViewSortColumnId"));
		objectViewSortColumnImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectViewSortColumnImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectViewSortColumnImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectViewSortColumnImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectViewSortColumnImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectViewSortColumnImpl.setObjectViewId(
			this.<Long>getColumnOriginalValue("objectViewId"));
		objectViewSortColumnImpl.setObjectFieldName(
			this.<String>getColumnOriginalValue("objectFieldName"));
		objectViewSortColumnImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));
		objectViewSortColumnImpl.setSortOrder(
			this.<String>getColumnOriginalValue("sortOrder"));

		return objectViewSortColumnImpl;
	}

	@Override
	public int compareTo(ObjectViewSortColumn objectViewSortColumn) {
		long primaryKey = objectViewSortColumn.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectViewSortColumn)) {
			return false;
		}

		ObjectViewSortColumn objectViewSortColumn =
			(ObjectViewSortColumn)object;

		long primaryKey = objectViewSortColumn.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectViewSortColumn> toCacheModel() {
		ObjectViewSortColumnCacheModel objectViewSortColumnCacheModel =
			new ObjectViewSortColumnCacheModel();

		objectViewSortColumnCacheModel.mvccVersion = getMvccVersion();

		objectViewSortColumnCacheModel.uuid = getUuid();

		String uuid = objectViewSortColumnCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectViewSortColumnCacheModel.uuid = null;
		}

		objectViewSortColumnCacheModel.objectViewSortColumnId =
			getObjectViewSortColumnId();

		objectViewSortColumnCacheModel.companyId = getCompanyId();

		objectViewSortColumnCacheModel.userId = getUserId();

		objectViewSortColumnCacheModel.userName = getUserName();

		String userName = objectViewSortColumnCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectViewSortColumnCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectViewSortColumnCacheModel.createDate = createDate.getTime();
		}
		else {
			objectViewSortColumnCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectViewSortColumnCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			objectViewSortColumnCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectViewSortColumnCacheModel.objectViewId = getObjectViewId();

		objectViewSortColumnCacheModel.objectFieldName = getObjectFieldName();

		String objectFieldName = objectViewSortColumnCacheModel.objectFieldName;

		if ((objectFieldName != null) && (objectFieldName.length() == 0)) {
			objectViewSortColumnCacheModel.objectFieldName = null;
		}

		objectViewSortColumnCacheModel.priority = getPriority();

		objectViewSortColumnCacheModel.sortOrder = getSortOrder();

		String sortOrder = objectViewSortColumnCacheModel.sortOrder;

		if ((sortOrder != null) && (sortOrder.length() == 0)) {
			objectViewSortColumnCacheModel.sortOrder = null;
		}

		return objectViewSortColumnCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectViewSortColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectViewSortColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewSortColumn, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectViewSortColumn)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectViewSortColumn>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectViewSortColumn.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectViewSortColumnId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectViewId;
	private String _objectFieldName;
	private int _priority;
	private String _sortOrder;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectViewSortColumn, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectViewSortColumn)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectViewSortColumnId", _objectViewSortColumnId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectViewId", _objectViewId);
		_columnOriginalValues.put("objectFieldName", _objectFieldName);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("sortOrder", _sortOrder);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectViewSortColumnId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectViewId", 256L);

		columnBitmasks.put("objectFieldName", 512L);

		columnBitmasks.put("priority", 1024L);

		columnBitmasks.put("sortOrder", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectViewSortColumn _escapedModel;

}