/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.model.ObjectViewFilterColumnModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectViewFilterColumn service. Represents a row in the &quot;ObjectViewFilterColumn&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectViewFilterColumnModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectViewFilterColumnImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectViewFilterColumnImpl
 * @generated
 */
public class ObjectViewFilterColumnModelImpl
	extends BaseModelImpl<ObjectViewFilterColumn>
	implements ObjectViewFilterColumnModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object view filter column model instance should use the <code>ObjectViewFilterColumn</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectViewFilterColumn";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectViewFilterColumnId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectViewId", Types.BIGINT}, {"filterType", Types.VARCHAR},
		{"json", Types.CLOB}, {"objectFieldName", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectViewFilterColumnId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectViewId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("filterType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("json", Types.CLOB);
		TABLE_COLUMNS_MAP.put("objectFieldName", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectViewFilterColumn (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectViewFilterColumnId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectViewId LONG,filterType VARCHAR(75) null,json TEXT null,objectFieldName VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table ObjectViewFilterColumn";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectViewFilterColumn.objectViewFilterColumnId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectViewFilterColumn.objectViewFilterColumnId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDNAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWFILTERCOLUMNID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectViewFilterColumnModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectViewFilterColumnId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectViewFilterColumnId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectViewFilterColumnId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectViewFilterColumn.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectViewFilterColumn.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectViewFilterColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectViewFilterColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewFilterColumn, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectViewFilterColumn)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectViewFilterColumn, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectViewFilterColumn, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectViewFilterColumn)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectViewFilterColumn, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectViewFilterColumn, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<ObjectViewFilterColumn, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectViewFilterColumn, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectViewFilterColumn, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectViewFilterColumn::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", ObjectViewFilterColumn::getUuid);
			attributeGetterFunctions.put(
				"objectViewFilterColumnId",
				ObjectViewFilterColumn::getObjectViewFilterColumnId);
			attributeGetterFunctions.put(
				"companyId", ObjectViewFilterColumn::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectViewFilterColumn::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectViewFilterColumn::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectViewFilterColumn::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectViewFilterColumn::getModifiedDate);
			attributeGetterFunctions.put(
				"objectViewId", ObjectViewFilterColumn::getObjectViewId);
			attributeGetterFunctions.put(
				"filterType", ObjectViewFilterColumn::getFilterType);
			attributeGetterFunctions.put(
				"json", ObjectViewFilterColumn::getJSON);
			attributeGetterFunctions.put(
				"objectFieldName", ObjectViewFilterColumn::getObjectFieldName);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<ObjectViewFilterColumn, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectViewFilterColumn, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectViewFilterColumn, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectViewFilterColumn, Long>)
					ObjectViewFilterColumn::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectViewFilterColumn, String>)
					ObjectViewFilterColumn::setUuid);
			attributeSetterBiConsumers.put(
				"objectViewFilterColumnId",
				(BiConsumer<ObjectViewFilterColumn, Long>)
					ObjectViewFilterColumn::setObjectViewFilterColumnId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectViewFilterColumn, Long>)
					ObjectViewFilterColumn::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectViewFilterColumn, Long>)
					ObjectViewFilterColumn::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectViewFilterColumn, String>)
					ObjectViewFilterColumn::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectViewFilterColumn, Date>)
					ObjectViewFilterColumn::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectViewFilterColumn, Date>)
					ObjectViewFilterColumn::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectViewId",
				(BiConsumer<ObjectViewFilterColumn, Long>)
					ObjectViewFilterColumn::setObjectViewId);
			attributeSetterBiConsumers.put(
				"filterType",
				(BiConsumer<ObjectViewFilterColumn, String>)
					ObjectViewFilterColumn::setFilterType);
			attributeSetterBiConsumers.put(
				"json",
				(BiConsumer<ObjectViewFilterColumn, String>)
					ObjectViewFilterColumn::setJSON);
			attributeSetterBiConsumers.put(
				"objectFieldName",
				(BiConsumer<ObjectViewFilterColumn, String>)
					ObjectViewFilterColumn::setObjectFieldName);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectViewFilterColumnId() {
		return _objectViewFilterColumnId;
	}

	@Override
	public void setObjectViewFilterColumnId(long objectViewFilterColumnId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewFilterColumnId = objectViewFilterColumnId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectViewId() {
		return _objectViewId;
	}

	@Override
	public void setObjectViewId(long objectViewId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewId = objectViewId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectViewId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectViewId"));
	}

	@Override
	public String getFilterType() {
		if (_filterType == null) {
			return "";
		}
		else {
			return _filterType;
		}
	}

	@Override
	public void setFilterType(String filterType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_filterType = filterType;
	}

	@Override
	public String getJSON() {
		if (_json == null) {
			return "";
		}
		else {
			return _json;
		}
	}

	@Override
	public void setJSON(String json) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_json = json;
	}

	@Override
	public String getObjectFieldName() {
		if (_objectFieldName == null) {
			return "";
		}
		else {
			return _objectFieldName;
		}
	}

	@Override
	public void setObjectFieldName(String objectFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldName = objectFieldName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalObjectFieldName() {
		return getColumnOriginalValue("objectFieldName");
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectViewFilterColumn.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectViewFilterColumn.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectViewFilterColumn toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectViewFilterColumn>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectViewFilterColumnImpl objectViewFilterColumnImpl =
			new ObjectViewFilterColumnImpl();

		objectViewFilterColumnImpl.setMvccVersion(getMvccVersion());
		objectViewFilterColumnImpl.setUuid(getUuid());
		objectViewFilterColumnImpl.setObjectViewFilterColumnId(
			getObjectViewFilterColumnId());
		objectViewFilterColumnImpl.setCompanyId(getCompanyId());
		objectViewFilterColumnImpl.setUserId(getUserId());
		objectViewFilterColumnImpl.setUserName(getUserName());
		objectViewFilterColumnImpl.setCreateDate(getCreateDate());
		objectViewFilterColumnImpl.setModifiedDate(getModifiedDate());
		objectViewFilterColumnImpl.setObjectViewId(getObjectViewId());
		objectViewFilterColumnImpl.setFilterType(getFilterType());
		objectViewFilterColumnImpl.setJSON(getJSON());
		objectViewFilterColumnImpl.setObjectFieldName(getObjectFieldName());

		objectViewFilterColumnImpl.resetOriginalValues();

		return objectViewFilterColumnImpl;
	}

	@Override
	public ObjectViewFilterColumn cloneWithOriginalValues() {
		ObjectViewFilterColumnImpl objectViewFilterColumnImpl =
			new ObjectViewFilterColumnImpl();

		objectViewFilterColumnImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectViewFilterColumnImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectViewFilterColumnImpl.setObjectViewFilterColumnId(
			this.<Long>getColumnOriginalValue("objectViewFilterColumnId"));
		objectViewFilterColumnImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectViewFilterColumnImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectViewFilterColumnImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectViewFilterColumnImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectViewFilterColumnImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectViewFilterColumnImpl.setObjectViewId(
			this.<Long>getColumnOriginalValue("objectViewId"));
		objectViewFilterColumnImpl.setFilterType(
			this.<String>getColumnOriginalValue("filterType"));
		objectViewFilterColumnImpl.setJSON(
			this.<String>getColumnOriginalValue("json"));
		objectViewFilterColumnImpl.setObjectFieldName(
			this.<String>getColumnOriginalValue("objectFieldName"));

		return objectViewFilterColumnImpl;
	}

	@Override
	public int compareTo(ObjectViewFilterColumn objectViewFilterColumn) {
		long primaryKey = objectViewFilterColumn.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectViewFilterColumn)) {
			return false;
		}

		ObjectViewFilterColumn objectViewFilterColumn =
			(ObjectViewFilterColumn)object;

		long primaryKey = objectViewFilterColumn.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectViewFilterColumn> toCacheModel() {
		ObjectViewFilterColumnCacheModel objectViewFilterColumnCacheModel =
			new ObjectViewFilterColumnCacheModel();

		objectViewFilterColumnCacheModel.mvccVersion = getMvccVersion();

		objectViewFilterColumnCacheModel.uuid = getUuid();

		String uuid = objectViewFilterColumnCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectViewFilterColumnCacheModel.uuid = null;
		}

		objectViewFilterColumnCacheModel.objectViewFilterColumnId =
			getObjectViewFilterColumnId();

		objectViewFilterColumnCacheModel.companyId = getCompanyId();

		objectViewFilterColumnCacheModel.userId = getUserId();

		objectViewFilterColumnCacheModel.userName = getUserName();

		String userName = objectViewFilterColumnCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectViewFilterColumnCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectViewFilterColumnCacheModel.createDate = createDate.getTime();
		}
		else {
			objectViewFilterColumnCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectViewFilterColumnCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			objectViewFilterColumnCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectViewFilterColumnCacheModel.objectViewId = getObjectViewId();

		objectViewFilterColumnCacheModel.filterType = getFilterType();

		String filterType = objectViewFilterColumnCacheModel.filterType;

		if ((filterType != null) && (filterType.length() == 0)) {
			objectViewFilterColumnCacheModel.filterType = null;
		}

		objectViewFilterColumnCacheModel.json = getJSON();

		String json = objectViewFilterColumnCacheModel.json;

		if ((json != null) && (json.length() == 0)) {
			objectViewFilterColumnCacheModel.json = null;
		}

		objectViewFilterColumnCacheModel.objectFieldName = getObjectFieldName();

		String objectFieldName =
			objectViewFilterColumnCacheModel.objectFieldName;

		if ((objectFieldName != null) && (objectFieldName.length() == 0)) {
			objectViewFilterColumnCacheModel.objectFieldName = null;
		}

		return objectViewFilterColumnCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectViewFilterColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectViewFilterColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewFilterColumn, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectViewFilterColumn)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectViewFilterColumn>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectViewFilterColumn.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectViewFilterColumnId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectViewId;
	private String _filterType;
	private String _json;
	private String _objectFieldName;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectViewFilterColumn, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectViewFilterColumn)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectViewFilterColumnId", _objectViewFilterColumnId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectViewId", _objectViewId);
		_columnOriginalValues.put("filterType", _filterType);
		_columnOriginalValues.put("json", _json);
		_columnOriginalValues.put("objectFieldName", _objectFieldName);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectViewFilterColumnId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectViewId", 256L);

		columnBitmasks.put("filterType", 512L);

		columnBitmasks.put("json", 1024L);

		columnBitmasks.put("objectFieldName", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectViewFilterColumn _escapedModel;

}