/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectFilter;
import com.liferay.object.model.ObjectFilterModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectFilter service. Represents a row in the &quot;ObjectFilter&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectFilterModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFilterImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFilterImpl
 * @generated
 */
public class ObjectFilterModelImpl
	extends BaseModelImpl<ObjectFilter> implements ObjectFilterModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object filter model instance should use the <code>ObjectFilter</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectFilter";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectFilterId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectFieldId", Types.BIGINT}, {"filterBy", Types.VARCHAR},
		{"filterType", Types.VARCHAR}, {"json", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFilterId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("filterBy", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("filterType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("json", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectFilter (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectFilterId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectFieldId LONG,filterBy VARCHAR(75) null,filterType VARCHAR(75) null,json VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectFilter";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectFilter.objectFilterId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectFilter.objectFilterId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFILTERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectFilterModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectFilterId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectFilterId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectFilterId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectFilter.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectFilter.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectFilter, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectFilter, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFilter, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectFilter)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectFilter, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectFilter, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectFilter)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectFilter, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectFilter, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectFilter, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectFilter, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<ObjectFilter, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectFilter::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectFilter::getUuid);
			attributeGetterFunctions.put(
				"objectFilterId", ObjectFilter::getObjectFilterId);
			attributeGetterFunctions.put(
				"companyId", ObjectFilter::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectFilter::getUserId);
			attributeGetterFunctions.put("userName", ObjectFilter::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectFilter::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectFilter::getModifiedDate);
			attributeGetterFunctions.put(
				"objectFieldId", ObjectFilter::getObjectFieldId);
			attributeGetterFunctions.put("filterBy", ObjectFilter::getFilterBy);
			attributeGetterFunctions.put(
				"filterType", ObjectFilter::getFilterType);
			attributeGetterFunctions.put("json", ObjectFilter::getJSON);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectFilter, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectFilter, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<ObjectFilter, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectFilter, Long>)ObjectFilter::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectFilter, String>)ObjectFilter::setUuid);
			attributeSetterBiConsumers.put(
				"objectFilterId",
				(BiConsumer<ObjectFilter, Long>)
					ObjectFilter::setObjectFilterId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectFilter, Long>)ObjectFilter::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectFilter, Long>)ObjectFilter::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectFilter, String>)ObjectFilter::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectFilter, Date>)ObjectFilter::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectFilter, Date>)ObjectFilter::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectFieldId",
				(BiConsumer<ObjectFilter, Long>)ObjectFilter::setObjectFieldId);
			attributeSetterBiConsumers.put(
				"filterBy",
				(BiConsumer<ObjectFilter, String>)ObjectFilter::setFilterBy);
			attributeSetterBiConsumers.put(
				"filterType",
				(BiConsumer<ObjectFilter, String>)ObjectFilter::setFilterType);
			attributeSetterBiConsumers.put(
				"json",
				(BiConsumer<ObjectFilter, String>)ObjectFilter::setJSON);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectFilterId() {
		return _objectFilterId;
	}

	@Override
	public void setObjectFilterId(long objectFilterId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFilterId = objectFilterId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectFieldId() {
		return _objectFieldId;
	}

	@Override
	public void setObjectFieldId(long objectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId = objectFieldId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFieldId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFieldId"));
	}

	@Override
	public String getFilterBy() {
		if (_filterBy == null) {
			return "";
		}
		else {
			return _filterBy;
		}
	}

	@Override
	public void setFilterBy(String filterBy) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_filterBy = filterBy;
	}

	@Override
	public String getFilterType() {
		if (_filterType == null) {
			return "";
		}
		else {
			return _filterType;
		}
	}

	@Override
	public void setFilterType(String filterType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_filterType = filterType;
	}

	@Override
	public String getJSON() {
		if (_json == null) {
			return "";
		}
		else {
			return _json;
		}
	}

	@Override
	public void setJSON(String json) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_json = json;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectFilter.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectFilter.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectFilter toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectFilter>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectFilterImpl objectFilterImpl = new ObjectFilterImpl();

		objectFilterImpl.setMvccVersion(getMvccVersion());
		objectFilterImpl.setUuid(getUuid());
		objectFilterImpl.setObjectFilterId(getObjectFilterId());
		objectFilterImpl.setCompanyId(getCompanyId());
		objectFilterImpl.setUserId(getUserId());
		objectFilterImpl.setUserName(getUserName());
		objectFilterImpl.setCreateDate(getCreateDate());
		objectFilterImpl.setModifiedDate(getModifiedDate());
		objectFilterImpl.setObjectFieldId(getObjectFieldId());
		objectFilterImpl.setFilterBy(getFilterBy());
		objectFilterImpl.setFilterType(getFilterType());
		objectFilterImpl.setJSON(getJSON());

		objectFilterImpl.resetOriginalValues();

		return objectFilterImpl;
	}

	@Override
	public ObjectFilter cloneWithOriginalValues() {
		ObjectFilterImpl objectFilterImpl = new ObjectFilterImpl();

		objectFilterImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectFilterImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		objectFilterImpl.setObjectFilterId(
			this.<Long>getColumnOriginalValue("objectFilterId"));
		objectFilterImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectFilterImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		objectFilterImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectFilterImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectFilterImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectFilterImpl.setObjectFieldId(
			this.<Long>getColumnOriginalValue("objectFieldId"));
		objectFilterImpl.setFilterBy(
			this.<String>getColumnOriginalValue("filterBy"));
		objectFilterImpl.setFilterType(
			this.<String>getColumnOriginalValue("filterType"));
		objectFilterImpl.setJSON(this.<String>getColumnOriginalValue("json"));

		return objectFilterImpl;
	}

	@Override
	public int compareTo(ObjectFilter objectFilter) {
		long primaryKey = objectFilter.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectFilter)) {
			return false;
		}

		ObjectFilter objectFilter = (ObjectFilter)object;

		long primaryKey = objectFilter.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectFilter> toCacheModel() {
		ObjectFilterCacheModel objectFilterCacheModel =
			new ObjectFilterCacheModel();

		objectFilterCacheModel.mvccVersion = getMvccVersion();

		objectFilterCacheModel.uuid = getUuid();

		String uuid = objectFilterCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectFilterCacheModel.uuid = null;
		}

		objectFilterCacheModel.objectFilterId = getObjectFilterId();

		objectFilterCacheModel.companyId = getCompanyId();

		objectFilterCacheModel.userId = getUserId();

		objectFilterCacheModel.userName = getUserName();

		String userName = objectFilterCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectFilterCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectFilterCacheModel.createDate = createDate.getTime();
		}
		else {
			objectFilterCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectFilterCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectFilterCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectFilterCacheModel.objectFieldId = getObjectFieldId();

		objectFilterCacheModel.filterBy = getFilterBy();

		String filterBy = objectFilterCacheModel.filterBy;

		if ((filterBy != null) && (filterBy.length() == 0)) {
			objectFilterCacheModel.filterBy = null;
		}

		objectFilterCacheModel.filterType = getFilterType();

		String filterType = objectFilterCacheModel.filterType;

		if ((filterType != null) && (filterType.length() == 0)) {
			objectFilterCacheModel.filterType = null;
		}

		objectFilterCacheModel.json = getJSON();

		String json = objectFilterCacheModel.json;

		if ((json != null) && (json.length() == 0)) {
			objectFilterCacheModel.json = null;
		}

		return objectFilterCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectFilter, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectFilter, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFilter, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectFilter)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectFilter>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectFilter.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectFilterId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectFieldId;
	private String _filterBy;
	private String _filterType;
	private String _json;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectFilter, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectFilter)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectFilterId", _objectFilterId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectFieldId", _objectFieldId);
		_columnOriginalValues.put("filterBy", _filterBy);
		_columnOriginalValues.put("filterType", _filterType);
		_columnOriginalValues.put("json", _json);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectFilterId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectFieldId", 256L);

		columnBitmasks.put("filterBy", 512L);

		columnBitmasks.put("filterType", 1024L);

		columnBitmasks.put("json", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectFilter _escapedModel;

}