/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.model.ObjectFieldSettingModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectFieldSetting service. Represents a row in the &quot;ObjectFieldSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectFieldSettingModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFieldSettingImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFieldSettingImpl
 * @generated
 */
public class ObjectFieldSettingModelImpl
	extends BaseModelImpl<ObjectFieldSetting>
	implements ObjectFieldSettingModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object field setting model instance should use the <code>ObjectFieldSetting</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectFieldSetting";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectFieldSettingId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectFieldId", Types.BIGINT}, {"name", Types.VARCHAR},
		{"value", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFieldSettingId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("value", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectFieldSetting (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectFieldSettingId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectFieldId LONG,name VARCHAR(75) null,value VARCHAR(255) null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectFieldSetting";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectFieldSetting.objectFieldSettingId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectFieldSetting.objectFieldSettingId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDSETTINGID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectFieldSettingModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectFieldSettingId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectFieldSettingId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectFieldSettingId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectFieldSetting.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectFieldSetting.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectFieldSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectFieldSetting, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFieldSetting, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectFieldSetting)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectFieldSetting, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectFieldSetting, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectFieldSetting)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectFieldSetting, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectFieldSetting, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectFieldSetting, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectFieldSetting, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectFieldSetting, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectFieldSetting::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectFieldSetting::getUuid);
			attributeGetterFunctions.put(
				"objectFieldSettingId",
				ObjectFieldSetting::getObjectFieldSettingId);
			attributeGetterFunctions.put(
				"companyId", ObjectFieldSetting::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectFieldSetting::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectFieldSetting::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectFieldSetting::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectFieldSetting::getModifiedDate);
			attributeGetterFunctions.put(
				"objectFieldId", ObjectFieldSetting::getObjectFieldId);
			attributeGetterFunctions.put("name", ObjectFieldSetting::getName);
			attributeGetterFunctions.put("value", ObjectFieldSetting::getValue);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectFieldSetting, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectFieldSetting, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectFieldSetting, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectFieldSetting, Long>)
					ObjectFieldSetting::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectFieldSetting, String>)
					ObjectFieldSetting::setUuid);
			attributeSetterBiConsumers.put(
				"objectFieldSettingId",
				(BiConsumer<ObjectFieldSetting, Long>)
					ObjectFieldSetting::setObjectFieldSettingId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectFieldSetting, Long>)
					ObjectFieldSetting::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectFieldSetting, Long>)
					ObjectFieldSetting::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectFieldSetting, String>)
					ObjectFieldSetting::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectFieldSetting, Date>)
					ObjectFieldSetting::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectFieldSetting, Date>)
					ObjectFieldSetting::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectFieldId",
				(BiConsumer<ObjectFieldSetting, Long>)
					ObjectFieldSetting::setObjectFieldId);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectFieldSetting, String>)
					ObjectFieldSetting::setName);
			attributeSetterBiConsumers.put(
				"value",
				(BiConsumer<ObjectFieldSetting, String>)
					ObjectFieldSetting::setValue);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectFieldSettingId() {
		return _objectFieldSettingId;
	}

	@Override
	public void setObjectFieldSettingId(long objectFieldSettingId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldSettingId = objectFieldSettingId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectFieldId() {
		return _objectFieldId;
	}

	@Override
	public void setObjectFieldId(long objectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId = objectFieldId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFieldId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFieldId"));
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getValue() {
		if (_value == null) {
			return "";
		}
		else {
			return _value;
		}
	}

	@Override
	public void setValue(String value) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_value = value;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectFieldSetting.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectFieldSetting.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectFieldSetting toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectFieldSetting>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectFieldSettingImpl objectFieldSettingImpl =
			new ObjectFieldSettingImpl();

		objectFieldSettingImpl.setMvccVersion(getMvccVersion());
		objectFieldSettingImpl.setUuid(getUuid());
		objectFieldSettingImpl.setObjectFieldSettingId(
			getObjectFieldSettingId());
		objectFieldSettingImpl.setCompanyId(getCompanyId());
		objectFieldSettingImpl.setUserId(getUserId());
		objectFieldSettingImpl.setUserName(getUserName());
		objectFieldSettingImpl.setCreateDate(getCreateDate());
		objectFieldSettingImpl.setModifiedDate(getModifiedDate());
		objectFieldSettingImpl.setObjectFieldId(getObjectFieldId());
		objectFieldSettingImpl.setName(getName());
		objectFieldSettingImpl.setValue(getValue());

		objectFieldSettingImpl.resetOriginalValues();

		return objectFieldSettingImpl;
	}

	@Override
	public ObjectFieldSetting cloneWithOriginalValues() {
		ObjectFieldSettingImpl objectFieldSettingImpl =
			new ObjectFieldSettingImpl();

		objectFieldSettingImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectFieldSettingImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectFieldSettingImpl.setObjectFieldSettingId(
			this.<Long>getColumnOriginalValue("objectFieldSettingId"));
		objectFieldSettingImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectFieldSettingImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectFieldSettingImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectFieldSettingImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectFieldSettingImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectFieldSettingImpl.setObjectFieldId(
			this.<Long>getColumnOriginalValue("objectFieldId"));
		objectFieldSettingImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectFieldSettingImpl.setValue(
			this.<String>getColumnOriginalValue("value"));

		return objectFieldSettingImpl;
	}

	@Override
	public int compareTo(ObjectFieldSetting objectFieldSetting) {
		long primaryKey = objectFieldSetting.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectFieldSetting)) {
			return false;
		}

		ObjectFieldSetting objectFieldSetting = (ObjectFieldSetting)object;

		long primaryKey = objectFieldSetting.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectFieldSetting> toCacheModel() {
		ObjectFieldSettingCacheModel objectFieldSettingCacheModel =
			new ObjectFieldSettingCacheModel();

		objectFieldSettingCacheModel.mvccVersion = getMvccVersion();

		objectFieldSettingCacheModel.uuid = getUuid();

		String uuid = objectFieldSettingCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectFieldSettingCacheModel.uuid = null;
		}

		objectFieldSettingCacheModel.objectFieldSettingId =
			getObjectFieldSettingId();

		objectFieldSettingCacheModel.companyId = getCompanyId();

		objectFieldSettingCacheModel.userId = getUserId();

		objectFieldSettingCacheModel.userName = getUserName();

		String userName = objectFieldSettingCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectFieldSettingCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectFieldSettingCacheModel.createDate = createDate.getTime();
		}
		else {
			objectFieldSettingCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectFieldSettingCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectFieldSettingCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectFieldSettingCacheModel.objectFieldId = getObjectFieldId();

		objectFieldSettingCacheModel.name = getName();

		String name = objectFieldSettingCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectFieldSettingCacheModel.name = null;
		}

		objectFieldSettingCacheModel.value = getValue();

		String value = objectFieldSettingCacheModel.value;

		if ((value != null) && (value.length() == 0)) {
			objectFieldSettingCacheModel.value = null;
		}

		return objectFieldSettingCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectFieldSetting, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectFieldSetting, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFieldSetting, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectFieldSetting)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectFieldSetting>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectFieldSetting.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectFieldSettingId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectFieldId;
	private String _name;
	private String _value;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectFieldSetting, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectFieldSetting)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectFieldSettingId", _objectFieldSettingId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectFieldId", _objectFieldId);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("value", _value);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectFieldSettingId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectFieldId", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("value", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectFieldSetting _escapedModel;

}