/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.petra.sql.dsl;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;

import java.sql.Types;

/**
 * @author Marco Leo
 */
public class DynamicObjectRelationshipMappingTable
	extends BaseTable<DynamicObjectRelationshipMappingTable> {

	public DynamicObjectRelationshipMappingTable(
		String primaryKeyColumnName1, String primaryKeyColumnName2,
		String tableName) {

		super(tableName, () -> null);

		_primaryKeyColumnName1 = primaryKeyColumnName1;
		_primaryKeyColumnName2 = primaryKeyColumnName2;

		createColumn(
			_primaryKeyColumnName1, Long.class, Types.BIGINT,
			Column.FLAG_PRIMARY);
		createColumn(
			_primaryKeyColumnName2, Long.class, Types.BIGINT,
			Column.FLAG_PRIMARY);
	}

	public Column<DynamicObjectRelationshipMappingTable, Long>
		getPrimaryKeyColumn1() {

		return (Column<DynamicObjectRelationshipMappingTable, Long>)getColumn(
			_primaryKeyColumnName1);
	}

	public Column<DynamicObjectRelationshipMappingTable, Long>
		getPrimaryKeyColumn2() {

		return (Column<DynamicObjectRelationshipMappingTable, Long>)getColumn(
			_primaryKeyColumnName2);
	}

	private final String _primaryKeyColumnName1;
	private final String _primaryKeyColumnName2;

}