/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.related.models;

import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.exception.PortalException;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Marco Leo
 * @author Brian Wing Shun Chan
 */
@Component(service = ObjectRelatedModelsProviderRegistry.class)
public class ObjectRelatedModelsProviderRegistryImpl
	implements ObjectRelatedModelsProviderRegistry {

	@Override
	public ObjectRelatedModelsProvider getObjectRelatedModelsProvider(
			String className, String type)
		throws PortalException {

		String key = _getKey(className, type);

		ObjectRelatedModelsProvider objectRelatedModelsProvider =
			_serviceTrackerMap.getService(key);

		if (objectRelatedModelsProvider == null) {
			throw new IllegalArgumentException(
				"No object related models provider found with key " + key);
		}

		return objectRelatedModelsProvider;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, ObjectRelatedModelsProvider.class, null,
			(serviceReference, emitter) -> {
				ObjectRelatedModelsProvider objectRelatedModelsProvider =
					bundleContext.getService(serviceReference);

				emitter.emit(
					_getKey(
						objectRelatedModelsProvider.getClassName(),
						objectRelatedModelsProvider.
							getObjectRelationshipType()));
			});
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private String _getKey(String className, String type) {
		return className + StringPool.POUND + type;
	}

	private ServiceTrackerMap<String, ObjectRelatedModelsProvider>
		_serviceTrackerMap;

}