/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.related.models;

import com.liferay.object.related.models.ObjectRelatedModelsPredicateProvider;
import com.liferay.object.related.models.ObjectRelatedModelsPredicateProviderRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringPool;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Luis Miguel Barcos
 */
@Component(service = ObjectRelatedModelsPredicateProviderRegistry.class)
public class ObjectRelatedModelsPredicateProviderRegistryImpl
	implements ObjectRelatedModelsPredicateProviderRegistry {

	@Override
	public ObjectRelatedModelsPredicateProvider
		getObjectRelatedModelsPredicateProvider(String className, String type) {

		String key = _getKey(className, type);

		ObjectRelatedModelsPredicateProvider
			objectRelatedModelsPredicateProvider =
				_serviceTrackerMap.getService(key);

		if (objectRelatedModelsPredicateProvider == null) {
			throw new IllegalArgumentException(
				"No object related models predicate provider found with key " +
					key);
		}

		return objectRelatedModelsPredicateProvider;
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, ObjectRelatedModelsPredicateProvider.class, null,
			(serviceReference, emitter) -> {
				ObjectRelatedModelsPredicateProvider
					objectRelatedModelsPredicateProvider =
						bundleContext.getService(serviceReference);

				emitter.emit(
					_getKey(
						objectRelatedModelsPredicateProvider.getClassName(),
						objectRelatedModelsPredicateProvider.
							getObjectRelationshipType()));
			});
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private String _getKey(String className, String type) {
		return className + StringPool.POUND + type;
	}

	private ServiceTrackerMap<String, ObjectRelatedModelsPredicateProvider>
		_serviceTrackerMap;

}