/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.persistence;

import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.model.BaseModel;

/**
 * @author Rafael Praxedes
 */
public class ObjectDefinitionTableArgumentsResolver
	implements ArgumentsResolver {

	public ObjectDefinitionTableArgumentsResolver(String tableName) {
		_tableName = tableName;
	}

	@Override
	public Object[] getArguments(
		FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn,
		boolean original) {

		throw new UnsupportedOperationException();
	}

	@Override
	public String getClassName() {
		return _tableName;
	}

	@Override
	public String getTableName() {
		return _tableName;
	}

	private final String _tableName;

}