/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.notification.handler;

import com.liferay.notification.handler.NotificationHandler;
import com.liferay.object.model.ObjectDefinition;

import java.util.Locale;

/**
 * @author Feliphe Marinho
 */
public class ObjectDefinitionNotificationHandler
	implements NotificationHandler {

	public ObjectDefinitionNotificationHandler(
		ObjectDefinition objectDefinition) {

		_objectDefinition = objectDefinition;
	}

	@Override
	public String getTriggerBy(Locale locale) {
		return _objectDefinition.getShortName();
	}

	private final ObjectDefinition _objectDefinition;

}