/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.action.util;

import com.liferay.petra.lang.CentralizedThreadLocal;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Guilherme Camacho
 */
public class ObjectActionThreadLocal {

	public static void addObjectActionId(long objectActionId) {
		Set<Long> objectActionIds = getObjectActionIds();

		objectActionIds.add(objectActionId);
	}

	public static void clearObjectActionIds() {
		Set<Long> objectActionIds = getObjectActionIds();

		objectActionIds.clear();
	}

	public static Set<Long> getObjectActionIds() {
		return _objectActionIdsThreadLocal.get();
	}

	public static void setObjectActionIds(Set<Long> objectActionIds) {
		_objectActionIdsThreadLocal.set(objectActionIds);
	}

	private static final ThreadLocal<Set<Long>> _objectActionIdsThreadLocal =
		new CentralizedThreadLocal<>(
			ObjectActionThreadLocal.class.getName() +
				"._objectActionIdsThreadLocal",
			HashSet::new);

}