/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.query.contributor;

import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectView;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectViewLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.search.generic.TermRangeQueryImpl;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectEntryKeywordQueryContributor
implements KeywordQueryContributor {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryKeywordQueryContributor.class);
    private static final Pattern _pattern = Pattern.compile("\\d{14}");
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectViewLocalService _objectViewLocalService;

    public ObjectEntryKeywordQueryContributor(ObjectFieldLocalService objectFieldLocalService, ObjectViewLocalService objectViewLocalService) {
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectViewLocalService = objectViewLocalService;
    }

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        ObjectView defaultObjectView;
        if (Validator.isBlank((String)keywords)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        long objectDefinitionId = GetterUtil.getLong((Object)searchContext.getAttribute("objectDefinitionId"));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Object definition ID " + objectDefinitionId));
        }
        if (objectDefinitionId == 0L) {
            String className = keywordQueryContributorHelper.getClassName();
            if (className.startsWith("com.liferay.object.model.ObjectDefinition#")) {
                String[] parts = StringUtil.split((String)className, (String)"#");
                objectDefinitionId = Long.valueOf(parts[1]);
            } else {
                return;
            }
        }
        AtomicBoolean addObjectEntryTitle = new AtomicBoolean(true);
        List objectFields = null;
        if (GetterUtil.getBoolean((Object)searchContext.getAttribute("searchByObjectView")) && (defaultObjectView = this._objectViewLocalService.fetchDefaultObjectView(objectDefinitionId)) != null) {
            addObjectEntryTitle.set(false);
            List objectViewColumns = defaultObjectView.getObjectViewColumns();
            Stream stream = objectViewColumns.stream();
            objectFields = stream.peek(objectViewColumn -> {
                if (Objects.equals(objectViewColumn.getObjectFieldName(), "id")) {
                    addObjectEntryTitle.set(true);
                }
            }).map(objectViewColumn -> this._objectFieldLocalService.fetchObjectField(defaultObjectView.getObjectDefinitionId(), objectViewColumn.getObjectFieldName())).collect(Collectors.toList());
        }
        if (objectFields == null) {
            objectFields = this._objectFieldLocalService.getObjectFields(objectDefinitionId);
        }
        for (String token : this._tokenizeKeywords(keywords)) {
            if (addObjectEntryTitle.get() && !Validator.isBlank((String)token)) {
                try {
                    booleanQuery.add((Query)new TermQueryImpl("entryClassPK", token), BooleanClauseOccur.SHOULD);
                    String titleField = "objectEntryTitle";
                    booleanQuery.add((Query)new WildcardQueryImpl(titleField, token + "*"), BooleanClauseOccur.SHOULD);
                    QueryConfig queryConfig = searchContext.getQueryConfig();
                    queryConfig.addHighlightFieldNames(new String[]{"entryClassPK", titleField});
                }
                catch (ParseException parseException) {
                    throw new SystemException((Throwable)parseException);
                }
            }
            for (ObjectField objectField : objectFields) {
                try {
                    this._contribute(objectField, token, booleanQuery, searchContext);
                }
                catch (ParseException parseException) {
                    throw new SystemException((Throwable)parseException);
                }
            }
        }
    }

    private void _addNumericClause(String fieldName, BooleanQuery nestedBooleanQuery, ObjectField objectField, String token) throws ParseException {
        boolean addedRangeQuery = this._addRangeQuery(nestedBooleanQuery, fieldName, token, objectField.getDBType());
        if (!addedRangeQuery && this._isValidInput(token, objectField.getDBType())) {
            nestedBooleanQuery.add((Query)new TermQueryImpl(fieldName, token), BooleanClauseOccur.MUST);
        }
    }

    private boolean _addRangeQuery(BooleanQuery booleanQuery, String fieldName, String token, String type) throws ParseException {
        String upperTerm;
        if (Validator.isBlank((String)token)) {
            return false;
        }
        String[] range = RangeParserUtil.parserRange((String)token);
        String lowerTerm = range[0];
        if (!this._isValidRange(lowerTerm, type, upperTerm = range[1])) {
            return false;
        }
        booleanQuery.add((Query)new TermRangeQueryImpl(fieldName, lowerTerm, upperTerm, true, true), BooleanClauseOccur.MUST);
        return true;
    }

    private void _contribute(ObjectField objectField, String token, BooleanQuery booleanQuery, SearchContext searchContext) throws ParseException {
        String fieldName;
        if (objectField == null || !objectField.isIndexed()) {
            return;
        }
        token = this._getToken(objectField.getName(), searchContext, token);
        if (Validator.isNull((String)token)) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Add search term ", token, " for object field ", objectField.getName()}));
        }
        BooleanQueryImpl nestedBooleanQuery = new BooleanQueryImpl();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (objectField.isIndexedAsKeyword()) {
            fieldName = "nestedFieldArray.value_keyword";
            String lowerCaseToken = StringUtil.toLowerCase((String)token);
            nestedBooleanQuery.add((Query)new WildcardQueryImpl(fieldName, lowerCaseToken + "*"), BooleanClauseOccur.MUST);
            nestedBooleanQuery.add((Query)new TermQueryImpl(fieldName, lowerCaseToken), BooleanClauseOccur.SHOULD);
            queryConfig.addHighlightFieldNames(new String[]{fieldName});
        } else if (Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(objectField.getDBType(), "Clob") || Objects.equals(objectField.getDBType(), "String")) {
            fieldName = "nestedFieldArray.value_text";
            if (Objects.equals(objectField.getIndexedLanguageId(), searchContext.getLanguageId())) {
                fieldName = "nestedFieldArray.value_" + objectField.getIndexedLanguageId();
            }
            nestedBooleanQuery.add((Query)new MatchQuery(fieldName, token), BooleanClauseOccur.MUST);
            queryConfig.addHighlightFieldNames(new String[]{fieldName});
        } else if (Objects.equals(objectField.getDBType(), "BigDecimal")) {
            this._addNumericClause("nestedFieldArray.value_double", (BooleanQuery)nestedBooleanQuery, objectField, token);
        } else if (Objects.equals(objectField.getDBType(), "Blob")) {
            _log.error((Object)"Blob type is not indexable");
        } else if (Objects.equals(objectField.getDBType(), "Boolean")) {
            fieldName = null;
            if (StringUtil.equalsIgnoreCase((String)token, (String)"false") || StringUtil.equalsIgnoreCase((String)token, (String)"true")) {
                fieldName = "nestedFieldArray.value_boolean";
            } else if (StringUtil.equalsIgnoreCase((String)token, (String)"no") || StringUtil.equalsIgnoreCase((String)token, (String)"yes")) {
                fieldName = "nestedFieldArray.value_keyword";
            }
            if (fieldName != null) {
                nestedBooleanQuery.add((Query)new TermQueryImpl(fieldName, StringUtil.toLowerCase((String)token)), BooleanClauseOccur.MUST);
                queryConfig.addHighlightFieldNames(new String[]{fieldName});
            }
        } else if (Objects.equals(objectField.getDBType(), "Date")) {
            this._addNumericClause("nestedFieldArray.value_date", (BooleanQuery)nestedBooleanQuery, objectField, token);
        } else if (Objects.equals(objectField.getDBType(), "Double")) {
            this._addNumericClause("nestedFieldArray.value_double", (BooleanQuery)nestedBooleanQuery, objectField, token);
        } else if (Objects.equals(objectField.getDBType(), "Integer")) {
            this._addNumericClause("nestedFieldArray.value_integer", (BooleanQuery)nestedBooleanQuery, objectField, token);
        } else if (Objects.equals(objectField.getDBType(), "Long")) {
            this._addNumericClause("nestedFieldArray.value_long", (BooleanQuery)nestedBooleanQuery, objectField, token);
        }
        if (nestedBooleanQuery.hasClauses()) {
            BooleanClauseOccur booleanClauseOccur = BooleanClauseOccur.SHOULD;
            if (searchContext.isAndSearch()) {
                booleanClauseOccur = BooleanClauseOccur.MUST;
            }
            booleanQuery.add((Query)new NestedQuery("nestedFieldArray", (Query)nestedBooleanQuery), booleanClauseOccur);
            nestedBooleanQuery.add((Query)new TermQueryImpl("nestedFieldArray.fieldName", objectField.getName()), BooleanClauseOccur.MUST);
        }
    }

    private String _getToken(String fieldName, SearchContext searchContext, String token) {
        if (Validator.isNotNull((String)token)) {
            return token;
        }
        String value = "";
        Serializable serializable = searchContext.getAttribute(fieldName);
        if (serializable != null) {
            Class<?> clazz = serializable.getClass();
            value = clazz.isArray() ? StringUtil.merge((Object[])((Object[])serializable)) : GetterUtil.getString((Object)serializable);
        }
        if (!Validator.isBlank((String)value) && searchContext.getFacet(fieldName) != null) {
            return null;
        }
        if (Validator.isBlank((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isBlank((String)value)) {
            return null;
        }
        return value;
    }

    private boolean _isValidInput(String token, String type) {
        block9: {
            if (token == null) {
                return false;
            }
            try {
                if (Objects.equals(type, "BigDecimal") || Objects.equals(type, "Double")) {
                    Double.valueOf(token);
                    break block9;
                }
                if (Objects.equals(type, "Date")) {
                    Matcher matcher = _pattern.matcher(token);
                    if (!matcher.matches()) {
                        return false;
                    }
                    break block9;
                }
                if (Objects.equals(type, "Integer")) {
                    Integer.valueOf(token);
                    break block9;
                }
                if (Objects.equals(type, "Long")) {
                    Long.valueOf(token);
                    break block9;
                }
                return false;
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return false;
            }
        }
        return true;
    }

    private boolean _isValidRange(String lowerTerm, String type, String upperTerm) {
        return this._isValidInput(lowerTerm, type) && this._isValidInput(upperTerm, type);
    }

    private List<String> _tokenizeKeywords(String keywords) {
        KeywordTokenizer keywordTokenizer = new KeywordTokenizer();
        return keywordTokenizer.tokenize(keywords);
    }

    private class KeywordTokenizer {
        private static final char _IDEOGRAPHIC_SPACE = '\u3000';

        private KeywordTokenizer() {
        }

        public List<String> tokenize(String keywords) {
            keywords = this._normalizeWhitespace(keywords);
            ArrayList<String> tokens = new ArrayList<String>();
            int[] startAndEnd = this.getStartAndEnd(keywords);
            this.tokenize(keywords, tokens, startAndEnd[0], startAndEnd[1]);
            return tokens;
        }

        protected int[] getStartAndEnd(String keywords) {
            int quoteStart = keywords.indexOf(34);
            int rangeStart = keywords.indexOf(91);
            if (quoteStart == -1) {
                return new int[]{rangeStart, keywords.indexOf(93, rangeStart + 1)};
            }
            if (rangeStart == -1) {
                return new int[]{quoteStart, keywords.indexOf(34, quoteStart + 1)};
            }
            if (quoteStart < rangeStart) {
                return new int[]{quoteStart, keywords.indexOf(34, quoteStart + 1)};
            }
            return new int[]{rangeStart, keywords.indexOf(93, rangeStart + 1)};
        }

        protected String[] split(String keywords) {
            if (Objects.equals(keywords, "null")) {
                return new String[]{keywords};
            }
            return StringUtil.split((String)keywords, (char)' ');
        }

        protected void tokenize(String keywords, List<String> tokens, int start, int end) {
            if (start == -1 || end == -1) {
                if (!(keywords = keywords.trim()).isEmpty()) {
                    this.tokenizeBySpace(keywords, tokens);
                }
                return;
            }
            String token = keywords.substring(0, start);
            if (!(token = token.trim()).isEmpty()) {
                this.tokenizeBySpace(token, tokens);
            }
            token = keywords.substring(start, end + 1);
            if (!(token = token.trim()).isEmpty()) {
                if (StringUtil.startsWith((String)token, (char)'\"')) {
                    token = StringUtil.unquote((String)token);
                }
                tokens.add(token);
            }
            if (end + 1 > keywords.length()) {
                return;
            }
            keywords = keywords.substring(end + 1);
            if ((keywords = keywords.trim()).isEmpty()) {
                return;
            }
            int[] startAndEnd = this.getStartAndEnd(keywords);
            this.tokenize(keywords, tokens, startAndEnd[0], startAndEnd[1]);
        }

        protected void tokenizeBySpace(String keywords, List<String> tokens) {
            String[] keywordTokens;
            for (String keywordToken : keywordTokens = this.split(keywords)) {
                String token = keywordToken.trim();
                if (token.isEmpty()) continue;
                tokens.add(token);
            }
        }

        private String _normalizeWhitespace(String keywords) {
            return StringUtil.replace((String)keywords, (char)'\u3000', (char)' ');
        }
    }
}

