/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldTable;
import com.liferay.object.model.ObjectRelationshipTable;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.model.ObjectViewFilterColumnTable;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.service.ObjectViewFilterColumnLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryModelListener.class);
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    @Reference
    private ObjectViewFilterColumnLocalService _objectViewFilterColumnLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._route("ADD", null, objectEntry);
        this._executeObjectActions("onAfterAdd", null, objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._route("DELETE", null, objectEntry);
        try {
            this._updateObjectViewFilterColumn("", objectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
        this._executeObjectActions("onAfterDelete", null, objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._route("UPDATE", originalObjectEntry, objectEntry);
        this._executeObjectActions("onAfterUpdate", originalObjectEntry, objectEntry);
        if (StringUtil.equals((String)originalObjectEntry.getExternalReferenceCode(), (String)objectEntry.getExternalReferenceCode())) {
            return;
        }
        try {
            this._updateObjectViewFilterColumn(objectEntry.getExternalReferenceCode(), originalObjectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(objectEntry);
    }

    public void onBeforeUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._validateObjectEntry(objectEntry);
    }

    private void _executeObjectActions(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            this._objectActionEngine.executeObjectActions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectActionTriggerKey, this._getPayloadJSONObject(objectActionTriggerKey, originalObjectEntry, objectEntry, userId), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private AuditMessage _getAuditMessage(String eventType, ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)objectEntry.getModelClassName(), (long)objectEntry.getObjectEntryId(), null);
        JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            Map values = objectEntry.getValues();
            additionalInfoJSONObject.put(objectField.getName(), this._getAuditValue(objectField, values.get(objectField.getName())));
        }
        return auditMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object _getAuditValue(ObjectField objectField, Object value) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            long dlFileEntryId = GetterUtil.getLong((Object)value);
            try {
                DLFileEntry dlFileEntry = this._dlFileEntryLocalService.getDLFileEntry(dlFileEntryId);
                return JSONUtil.put((String)"dlFileEntryId", (Object)dlFileEntryId).put("title", dlFileEntry.getTitle());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
                return value;
            }
        } else if (Objects.equals(objectField.getBusinessType(), "Picklist")) {
            String key = GetterUtil.getString((Object)value);
            try {
                ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.getListTypeEntry(objectField.getListTypeDefinitionId(), key);
                return JSONUtil.put((String)"key", (Object)key).put("name", listTypeEntry.getNameCurrentValue());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
                return value;
            }
        } else {
            if (!Objects.equals(objectField.getBusinessType(), "Relationship")) return value;
            long objectEntryId = GetterUtil.getLong((Object)value);
            try {
                ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntryId);
                return JSONUtil.put((String)"objectEntryId", (Object)objectEntryId).put("titleValue", objectEntry.getTitleValue());
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) return value;
                _log.debug((Throwable)portalException);
            }
        }
        return value;
    }

    private List<Attribute> _getModifiedAttributes(ObjectDefinition objectDefinition, Map<String, Serializable> originalValues, Map<String, Serializable> values) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            Serializable value;
            Serializable originalValue = originalValues.get(objectField.getName());
            if (Objects.equals(originalValue, value = values.get(objectField.getName()))) continue;
            attributes.add(new Attribute(objectField.getName(), this._getAuditValue(objectField, value), this._getAuditValue(objectField, originalValue)));
        }
        return attributes;
    }

    private String _getObjectDefinitionShortName(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        return objectDefinition.getShortName();
    }

    private JSONObject _getPayloadJSONObject(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry, long userId) throws PortalException {
        String objectDefinitionShortName = this._getObjectDefinitionShortName(objectEntry.getObjectDefinitionId());
        User user = this._userLocalService.getUser(userId);
        return JSONUtil.put((String)"classPK", (Object)objectEntry.getObjectEntryId()).put("objectActionTriggerKey", objectActionTriggerKey).put("objectEntry", (Object)HashMapBuilder.putAll((Map)objectEntry.getModelAttributes()).put((Object)"creator", (Object)user.getFullName()).put((Object)"id", (Object)objectEntry.getObjectEntryId()).put((Object)"values", (Object)objectEntry.getValues()).build()).put("objectEntryDTO" + objectDefinitionShortName, this._toDTO(objectEntry, user)).put("originalObjectEntry", () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return HashMapBuilder.putAll((Map)originalObjectEntry.getModelAttributes()).put((Object)"values", (Object)originalObjectEntry.getValues()).build();
        }).put("originalObjectEntryDTO" + objectDefinitionShortName, () -> {
            if (originalObjectEntry == null) {
                return null;
            }
            return this._toDTO(originalObjectEntry, user);
        });
    }

    private void _route(String eventType, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            if (!objectDefinition.isEnableObjectEntryHistory()) {
                return;
            }
            if (StringUtil.equals((String)"UPDATE", (String)eventType)) {
                this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)objectEntry.getModelClassName(), (long)objectEntry.getObjectEntryId(), this._getModifiedAttributes(objectDefinition, originalObjectEntry.getValues(), objectEntry.getValues())));
            } else {
                this._auditRouter.route(this._getAuditMessage(eventType, objectDefinition, objectEntry));
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private Map<String, Object> _toDTO(ObjectEntry objectEntry, User user) throws PortalException {
        DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(ObjectEntry.class.getName());
        if (dtoConverter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No DTO converter found for " + ObjectEntry.class.getName()));
            }
            return objectEntry.getModelAttributes();
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, null, user.getLocale(), null, user);
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep(dtoConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, (Object)objectEntry)));
            return jsonObject.toMap();
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return objectEntry.getModelAttributes();
        }
    }

    private void _updateObjectViewFilterColumn(String externalReferenceCode, ObjectEntry objectEntry) throws PortalException {
        List objectViewFilterColumns = (List)this._objectViewFilterColumnLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)ObjectViewFilterColumnTable.INSTANCE).from((Table)ObjectViewFilterColumnTable.INSTANCE).innerJoinON((Table)ObjectFieldTable.INSTANCE, ObjectFieldTable.INSTANCE.name.eq((Expression)ObjectViewFilterColumnTable.INSTANCE.objectFieldName)).innerJoinON((Table)ObjectRelationshipTable.INSTANCE, ObjectRelationshipTable.INSTANCE.objectFieldId2.eq((Expression)ObjectFieldTable.INSTANCE.objectFieldId)).where(ObjectRelationshipTable.INSTANCE.objectDefinitionId1.eq((Object)objectEntry.getObjectDefinitionId())));
        for (ObjectViewFilterColumn objectViewFilterColumn : objectViewFilterColumns) {
            JSONArray valueJSONArray = objectViewFilterColumn.getJSONArray();
            JSONArrayImpl newValueJSONArray = new JSONArrayImpl();
            for (int i = 0; i < valueJSONArray.length(); ++i) {
                if (StringUtil.equals((String)((String)valueJSONArray.get(i)), (String)objectEntry.getExternalReferenceCode())) {
                    if (StringUtil.equals((String)externalReferenceCode, (String)"")) continue;
                    newValueJSONArray.put(externalReferenceCode);
                    continue;
                }
                newValueJSONArray.put((String)valueJSONArray.get(i));
            }
            if (newValueJSONArray.length() == 0) {
                this._objectViewFilterColumnLocalService.deleteObjectViewFilterColumn(objectViewFilterColumn);
                continue;
            }
            objectViewFilterColumn.setJSON(StringBundler.concat((Object[])new Object[]{"{\"", objectViewFilterColumn.getFilterType(), "\":", newValueJSONArray, "}"}));
            this._objectViewFilterColumnLocalService.updateObjectViewFilterColumn(objectViewFilterColumn);
        }
    }

    private void _validateObjectEntry(ObjectEntry objectEntry) throws ModelListenerException {
        try {
            this._objectValidationRuleLocalService.validate((BaseModel)objectEntry, objectEntry.getObjectDefinitionId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

