/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.instance.lifecycle;

import com.liferay.item.selector.ItemSelectorView;
import com.liferay.item.selector.ItemSelectorViewDescriptorRenderer;
import com.liferay.item.selector.criteria.info.item.criterion.InfoItemItemSelectorCriterion;
import com.liferay.notification.handler.NotificationHandler;
import com.liferay.notification.term.contributor.NotificationTermContributor;
import com.liferay.object.constants.ObjectSAPConstants;
import com.liferay.object.internal.item.selector.SystemObjectEntryItemSelectorView;
import com.liferay.object.internal.notification.handler.ObjectDefinitionNotificationHandler;
import com.liferay.object.internal.notification.term.contributor.ObjectDefinitionNotificationTermContributor;
import com.liferay.object.internal.persistence.ObjectDefinitionTableArgumentsResolver;
import com.liferay.object.internal.related.models.SystemObject1toMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.related.models.SystemObjectMtoMObjectRelatedModelsProviderImpl;
import com.liferay.object.internal.rest.context.path.RESTContextPathResolverImpl;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.rest.context.path.RESTContextPathResolver;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={PortalInstanceLifecycleListener.class})
public class SystemObjectDefinitionMetadataPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.class);
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ItemSelectorViewDescriptorRenderer<InfoItemItemSelectorCriterion> _itemSelectorViewDescriptorRenderer;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private Portal _portal;
    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.object.service)(release.schema.version>=1.0.0))")
    private Release _release;
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private ServiceTrackerList<SystemObjectDefinitionMetadata> _serviceTrackerList;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registered portal instance " + company));
        }
        try {
            this._addSAPEntry(company.getCompanyId());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
        }
        for (SystemObjectDefinitionMetadata systemObjectDefinitionMetadata : this._serviceTrackerList) {
            this._apply(company.getCompanyId(), systemObjectDefinitionMetadata);
        }
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + bundleContext));
        }
        this._bundleContext = bundleContext;
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, SystemObjectDefinitionMetadata.class, null, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SystemObjectDefinitionMetadata, SystemObjectDefinitionMetadata>(){

            public SystemObjectDefinitionMetadata addingService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference) {
                SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = (SystemObjectDefinitionMetadata)bundleContext.getService(serviceReference);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding service " + systemObjectDefinitionMetadata));
                }
                SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.this._companyLocalService.forEachCompanyId(companyId -> SystemObjectDefinitionMetadataPortalInstanceLifecycleListener.this._apply(companyId, systemObjectDefinitionMetadata));
                return systemObjectDefinitionMetadata;
            }

            public void modifiedService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
            }

            public void removedService(ServiceReference<SystemObjectDefinitionMetadata> serviceReference, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    private void _addSAPEntry(long companyId) throws PortalException {
        SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, "OBJECT_DEFAULT");
        if (sapEntry != null) {
            return;
        }
        this._sapEntryLocalService.addSAPEntry(this._userLocalService.getDefaultUserId(companyId), ObjectSAPConstants.ALLOWED_SERVICE_SIGNATURES, true, true, "OBJECT_DEFAULT", ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER, (String)"service-access-policy-entry-default-object-title"), new ServiceContext());
    }

    private void _apply(long companyId, SystemObjectDefinitionMetadata systemObjectDefinitionMetadata) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Applying ", systemObjectDefinitionMetadata, " to company ", companyId}));
        }
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(companyId, systemObjectDefinitionMetadata.getName());
            if (objectDefinition == null || objectDefinition.getVersion() != systemObjectDefinitionMetadata.getVersion()) {
                objectDefinition = this._objectDefinitionLocalService.addOrUpdateSystemObjectDefinition(companyId, systemObjectDefinitionMetadata);
            }
            this._bundleContext.registerService(ArgumentsResolver.class, (Object)new ObjectDefinitionTableArgumentsResolver(objectDefinition.getExtensionDBTableName()), null);
            this._bundleContext.registerService(ItemSelectorView.class, (Object)new SystemObjectEntryItemSelectorView(this._itemSelectorViewDescriptorRenderer, objectDefinition, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelatedModelsProviderRegistry, this._portal, systemObjectDefinitionMetadata), (Dictionary)HashMapDictionaryBuilder.put((Object)"item.selector.view.order", (Object)500).build());
            this._bundleContext.registerService(NotificationTermContributor.class, (Object)new ObjectDefinitionNotificationTermContributor(objectDefinition, this._objectFieldLocalService, this._userLocalService), (Dictionary)HashMapDictionaryBuilder.put((Object)"notification.term.contributor.key", (Object)objectDefinition.getClassName()).put((Object)"notification.type.key", (Object)objectDefinition.getClassName()).build());
            this._bundleContext.registerService(NotificationHandler.class, (Object)new ObjectDefinitionNotificationHandler(objectDefinition), (Dictionary)HashMapDictionaryBuilder.put((Object)"class.name", (Object)objectDefinition.getClassName()).build());
            this._bundleContext.registerService(ObjectRelatedModelsProvider.class, new SystemObject1toMObjectRelatedModelsProviderImpl(objectDefinition, this._objectEntryLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._persistedModelLocalServiceRegistry, systemObjectDefinitionMetadata, this._systemObjectDefinitionMetadataRegistry), null);
            this._bundleContext.registerService(ObjectRelatedModelsProvider.class, new SystemObjectMtoMObjectRelatedModelsProviderImpl(objectDefinition, this._objectDefinitionLocalService, this._objectFieldLocalService, this._objectRelationshipLocalService, this._persistedModelLocalServiceRegistry, systemObjectDefinitionMetadata, this._systemObjectDefinitionMetadataRegistry), null);
            this._bundleContext.registerService(RESTContextPathResolver.class, (Object)new RESTContextPathResolverImpl("/o/" + systemObjectDefinitionMetadata.getRESTContextPath(), this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope()), true), (Dictionary)HashMapDictionaryBuilder.put((Object)"model.class.name", (Object)objectDefinition.getClassName()).build());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }
}

