/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectEntryLocalServiceUtil;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Relationship"}, service={ObjectFieldBusinessType.class, RelationshipObjectFieldBusinessType.class})
public class RelationshipObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private SystemObjectDefinitionMetadataRegistry _systemObjectDefinitionMetadataRegistry;

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "object-relationship";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "relationship");
    }

    public String getName() {
        return "Relationship";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"objectDefinition1ShortName", "objectRelationshipERCFieldName"});
    }

    public Object getValue(ObjectField objectField, Map<String, Object> values) throws PortalException {
        Object value = values.get(objectField.getName());
        if (!Objects.equals(objectField.getRelationshipType(), "oneToMany") || GetterUtil.getLong((Object)value) > 0L) {
            return value;
        }
        String externalReferenceCode = GetterUtil.getString((Object)values.get(ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCFieldName", (ObjectField)objectField)));
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByObjectFieldId2(objectField.getObjectFieldId());
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
        if (objectDefinition.isSystem()) {
            SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataRegistry.getSystemObjectDefinitionMetadata(objectDefinition.getName());
            BaseModel baseModel = systemObjectDefinitionMetadata.getBaseModelByExternalReferenceCode(externalReferenceCode, objectDefinition.getCompanyId());
            return baseModel.getPrimaryKeyObj();
        }
        return ObjectEntryLocalServiceUtil.getObjectEntryId((String)externalReferenceCode, (long)objectDefinition.getCompanyId(), (long)objectDefinition.getObjectDefinitionId());
    }

    public boolean isVisible() {
        return true;
    }
}

